/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.migration.MigrationInvoker;
import org.apache.dubbo.registry.client.migration.MigrationRuleHandler;
import org.apache.dubbo.registry.client.migration.model.MigrationRule;
import org.apache.dubbo.registry.integration.RegistryProtocol;
import org.apache.dubbo.registry.integration.RegistryProtocolListener;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.model.ModuleModel;

@Activate
public class MigrationRuleListener
implements RegistryProtocolListener,
ConfigurationListener {
    private static final Logger logger = LoggerFactory.getLogger(MigrationRuleListener.class);
    private static final String DUBBO_SERVICEDISCOVERY_MIGRATION = "DUBBO_SERVICEDISCOVERY_MIGRATION";
    private static final String MIGRATION_DELAY_KEY = "dubbo.application.migration.delay";
    private static final int MIGRATION_DEFAULT_DELAY_TIME = 60000;
    private String ruleKey;
    protected final Map<MigrationInvoker, MigrationRuleHandler> handlers = new ConcurrentHashMap<MigrationInvoker, MigrationRuleHandler>();
    protected final LinkedBlockingQueue<String> ruleQueue = new LinkedBlockingQueue();
    private final AtomicBoolean executorSubmit = new AtomicBoolean(false);
    private final ExecutorService ruleManageExecutor = Executors.newFixedThreadPool(1, new NamedThreadFactory("Dubbo-Migration-Listener"));
    protected ScheduledFuture<?> localRuleMigrationFuture;
    protected Future<?> ruleMigrationFuture;
    private DynamicConfiguration configuration;
    private volatile String rawRule;
    private volatile MigrationRule rule;
    private ModuleModel moduleModel;

    public MigrationRuleListener(ModuleModel moduleModel) {
        this.moduleModel = moduleModel;
        this.init();
    }

    private void init() {
        this.ruleKey = this.moduleModel.getApplicationModel().getApplicationName() + ".migration";
        this.configuration = this.moduleModel.getModelEnvironment().getDynamicConfiguration().orElse(null);
        if (this.configuration != null) {
            logger.info("Listening for migration rules on dataId " + this.ruleKey + ", group " + DUBBO_SERVICEDISCOVERY_MIGRATION);
            this.configuration.addListener(this.ruleKey, DUBBO_SERVICEDISCOVERY_MIGRATION, this);
            String rawRule = this.configuration.getConfig(this.ruleKey, DUBBO_SERVICEDISCOVERY_MIGRATION);
            if (StringUtils.isEmpty(rawRule)) {
                rawRule = "INIT";
            }
            this.setRawRule(rawRule);
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn("Using default configuration rule because config center is not configured!");
            }
            this.setRawRule("INIT");
        }
        String localRawRule = this.moduleModel.getModelEnvironment().getLocalMigrationRule();
        if (!StringUtils.isEmpty(localRawRule)) {
            this.localRuleMigrationFuture = this.moduleModel.getApplicationModel().getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class).getSharedScheduledExecutor().schedule(() -> {
                if (this.rawRule.equals("INIT")) {
                    this.process(new ConfigChangedEvent(null, null, localRawRule));
                }
            }, (long)this.getDelay(), TimeUnit.MILLISECONDS);
        }
    }

    private int getDelay() {
        int delay = 60000;
        String delayStr = ConfigurationUtils.getProperty(this.moduleModel, MIGRATION_DELAY_KEY);
        if (StringUtils.isEmpty(delayStr)) {
            return delay;
        }
        try {
            delay = Integer.parseInt(delayStr);
        }
        catch (Exception e) {
            logger.warn("Invalid migration delay param " + delayStr);
        }
        return delay;
    }

    @Override
    public synchronized void process(ConfigChangedEvent event) {
        String rawRule = event.getContent();
        if (StringUtils.isEmpty(rawRule)) {
            rawRule = "INIT";
        }
        try {
            this.ruleQueue.put(rawRule);
        }
        catch (InterruptedException e) {
            logger.error("Put rawRule to rule management queue failed. rawRule: " + rawRule, e);
        }
        if (this.executorSubmit.compareAndSet(false, true)) {
            this.ruleMigrationFuture = this.ruleManageExecutor.submit(() -> {
                while (true) {
                    String rule = "";
                    try {
                        rule = this.ruleQueue.take();
                        if (StringUtils.isEmpty(rule)) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.error("Poll Rule from config center failed.", e);
                    }
                    if (StringUtils.isEmpty(rule)) continue;
                    if (Objects.equals(this.rawRule, rule)) {
                        logger.info("Ignore duplicated rule");
                        continue;
                    }
                    try {
                        logger.info("Using the following migration rule to migrate:");
                        logger.info(rule);
                        this.setRawRule(rule);
                        if (!CollectionUtils.isNotEmptyMap(this.handlers)) continue;
                        ExecutorService executorService = Executors.newFixedThreadPool(100, new NamedThreadFactory("Dubbo-Invoker-Migrate"));
                        ArrayList migrationFutures = new ArrayList(this.handlers.size());
                        this.handlers.forEach((_key, handler) -> {
                            Future<?> future = executorService.submit(() -> handler.doMigrate(this.rule));
                            migrationFutures.add(future);
                        });
                        Throwable migrationException = null;
                        for (Future future : migrationFutures) {
                            try {
                                future.get();
                            }
                            catch (InterruptedException ie) {
                                logger.warn("Interrupted while waiting for migration async task to finish.");
                            }
                            catch (ExecutionException ee) {
                                migrationException = ee.getCause();
                            }
                        }
                        if (migrationException != null) {
                            logger.error("Migration async task failed.", migrationException);
                        }
                        executorService.shutdown();
                        continue;
                    }
                    catch (Throwable t) {
                        logger.error("Error occurred when migration.", t);
                        continue;
                    }
                    break;
                }
            });
        }
    }

    public void setRawRule(String rawRule) {
        this.rawRule = rawRule;
        this.rule = this.parseRule(this.rawRule);
    }

    private MigrationRule parseRule(String rawRule) {
        MigrationRule tmpRule;
        MigrationRule migrationRule = tmpRule = this.rule == null ? MigrationRule.getInitRule() : this.rule;
        if ("INIT".equals(rawRule)) {
            tmpRule = MigrationRule.getInitRule();
        } else {
            try {
                tmpRule = MigrationRule.parse(rawRule);
            }
            catch (Exception e) {
                logger.error("Failed to parse migration rule...", e);
            }
        }
        return tmpRule;
    }

    @Override
    public void onExport(RegistryProtocol registryProtocol, Exporter<?> exporter) {
    }

    @Override
    public void onRefer(RegistryProtocol registryProtocol, ClusterInvoker<?> invoker, URL consumerUrl, URL registryURL) {
        MigrationRuleHandler migrationRuleHandler = this.handlers.computeIfAbsent((MigrationInvoker)invoker, _key -> {
            ((MigrationInvoker)invoker).setMigrationRuleListener(this);
            return new MigrationRuleHandler((MigrationInvoker)invoker, consumerUrl);
        });
        migrationRuleHandler.doMigrate(this.rule);
    }

    @Override
    public void onDestroy() {
        if (this.configuration != null) {
            this.configuration.removeListener(this.ruleKey, DUBBO_SERVICEDISCOVERY_MIGRATION, this);
        }
        if (this.ruleMigrationFuture != null) {
            this.ruleMigrationFuture.cancel(true);
        }
        if (this.localRuleMigrationFuture != null) {
            this.localRuleMigrationFuture.cancel(true);
        }
        if (this.ruleManageExecutor != null) {
            this.ruleManageExecutor.shutdown();
        }
        this.ruleQueue.clear();
    }

    public Map<MigrationInvoker, MigrationRuleHandler> getHandlers() {
        return this.handlers;
    }

    protected void removeMigrationInvoker(MigrationInvoker<?> migrationInvoker) {
        this.handlers.remove(migrationInvoker);
    }

    public MigrationRule getRule() {
        return this.rule;
    }
}

