/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.extension;

import java.util.Arrays;
import org.apache.dubbo.common.context.Lifecycle;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionInjector;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class SpringExtensionInjector
implements ExtensionInjector,
Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(SpringExtensionInjector.class);
    public static final String NAME = "spring";
    private ApplicationContext context;

    @Deprecated
    public static void addApplicationContext(ApplicationContext context) {
    }

    public static SpringExtensionInjector get(ExtensionAccessor extensionAccessor) {
        return (SpringExtensionInjector)extensionAccessor.getExtension(ExtensionInjector.class, NAME);
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public void init(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public <T> T getInstance(Class<T> type, String name) {
        if (this.context == null) {
            return null;
        }
        if (type.isInterface() && type.isAnnotationPresent(SPI.class)) {
            return null;
        }
        T bean = this.getOptionalBean((ListableBeanFactory)this.context, name, type);
        if (bean != null) {
            return bean;
        }
        return null;
    }

    private <T> T getOptionalBean(ListableBeanFactory beanFactory, String name, Class<T> type) {
        if (StringUtils.isEmpty(name)) {
            Object[] beanNamesForType = beanFactory.getBeanNamesForType(type, true, false);
            if (beanNamesForType != null) {
                if (beanNamesForType.length == 1) {
                    return (T)beanFactory.getBean(beanNamesForType[0], type);
                }
                if (beanNamesForType.length > 1) {
                    throw new IllegalStateException("Expect single but found " + beanNamesForType.length + " beans in spring context: " + Arrays.toString(beanNamesForType));
                }
            }
        } else if (beanFactory.containsBean(name)) {
            return (T)beanFactory.getBean(name, type);
        }
        return null;
    }

    @Override
    public void initialize() throws IllegalStateException {
    }

    @Override
    public void start() throws IllegalStateException {
    }

    @Override
    public void destroy() {
    }
}

