/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;

public class DubboSpringInitContext {
    private BeanDefinitionRegistry registry;
    private ConfigurableListableBeanFactory beanFactory;
    private ApplicationContext applicationContext;
    private ModuleModel moduleModel;
    private Map<String, Object> moduleAttributes = new HashMap<String, Object>();
    private volatile boolean bound;

    public void markAsBound() {
        this.bound = true;
    }

    public BeanDefinitionRegistry getRegistry() {
        return this.registry;
    }

    void setRegistry(BeanDefinitionRegistry registry) {
        this.registry = registry;
    }

    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    void setBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ApplicationModel getApplicationModel() {
        return this.moduleModel == null ? null : this.moduleModel.getApplicationModel();
    }

    public ModuleModel getModuleModel() {
        return this.moduleModel;
    }

    public void setModuleModel(ModuleModel moduleModel) {
        if (this.bound) {
            throw new IllegalStateException("Cannot change ModuleModel after bound context");
        }
        this.moduleModel = moduleModel;
    }

    public boolean isKeepRunningOnSpringClosed() {
        return (Boolean)this.moduleAttributes.get("keepRunningOnSpringClosed");
    }

    public void setKeepRunningOnSpringClosed(boolean keepRunningOnSpringClosed) {
        this.setModuleAttribute("keepRunningOnSpringClosed", keepRunningOnSpringClosed);
    }

    public Map<String, Object> getModuleAttributes() {
        return this.moduleAttributes;
    }

    public void setModuleAttribute(String key, Object value) {
        this.moduleAttributes.put(key, value);
    }
}

