/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.proxy;

import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.profiler.Profiler;
import org.apache.dubbo.common.profiler.ProfilerEntry;
import org.apache.dubbo.common.profiler.ProfilerSwitch;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.RpcServiceContext;
import org.apache.dubbo.rpc.proxy.InvokerInvocationHandler;

public class InvocationUtil {
    private static final Logger logger = LoggerFactory.getLogger(InvokerInvocationHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invoke(Invoker<?> invoker, RpcInvocation rpcInvocation) throws Throwable {
        URL url = invoker.getUrl();
        String serviceKey = url.getServiceKey();
        rpcInvocation.setTargetServiceUniqueName(serviceKey);
        RpcServiceContext.getServiceContext().setConsumerUrl(url);
        if (ProfilerSwitch.isEnableSimpleProfiler()) {
            Object object;
            ProfilerEntry parentProfiler = Profiler.getBizProfiler();
            ProfilerEntry bizProfiler = parentProfiler != null ? Profiler.enter(parentProfiler, "Receive request. Client invoke begin. ServiceKey: " + serviceKey + " MethodName:" + rpcInvocation.getMethodName()) : Profiler.start("Receive request. Client invoke begin. ServiceKey: " + serviceKey + " MethodName:" + rpcInvocation.getMethodName());
            rpcInvocation.put("DUBBO_INVOKE_PROFILER", bizProfiler);
            try {
                object = invoker.invoke(rpcInvocation).recreate();
            }
            catch (Throwable throwable) {
                Profiler.release(bizProfiler);
                Object timeoutKey = rpcInvocation.getObjectAttachmentWithoutConvert("timeout");
                int timeout = timeoutKey instanceof Integer ? ((Integer)timeoutKey).intValue() : url.getMethodPositiveParameter(rpcInvocation.getMethodName(), "timeout", 1000);
                long usage = bizProfiler.getEndTime() - bizProfiler.getStartTime();
                if ((double)usage / (1000000.0 * ProfilerSwitch.getWarnPercent()) > (double)timeout) {
                    StringBuilder attachment = new StringBuilder();
                    for (Map.Entry<String, Object> entry : rpcInvocation.getObjectAttachments().entrySet()) {
                        attachment.append(entry.getKey()).append("=").append(entry.getValue()).append(";\n");
                    }
                    logger.warn(String.format("[Dubbo-Consumer] execute service %s#%s cost %d.%06d ms, this invocation almost (maybe already) timeout. Timeout: %dms\ninvocation context:\n%sthread info: \n%s", rpcInvocation.getProtocolServiceKey(), rpcInvocation.getMethodName(), usage / 1000000L, usage % 1000000L, timeout, attachment, Profiler.buildDetail(bizProfiler)));
                }
                throw throwable;
            }
            Profiler.release(bizProfiler);
            Object timeoutKey = rpcInvocation.getObjectAttachmentWithoutConvert("timeout");
            int timeout = timeoutKey instanceof Integer ? ((Integer)timeoutKey).intValue() : url.getMethodPositiveParameter(rpcInvocation.getMethodName(), "timeout", 1000);
            long usage = bizProfiler.getEndTime() - bizProfiler.getStartTime();
            if ((double)usage / (1000000.0 * ProfilerSwitch.getWarnPercent()) > (double)timeout) {
                StringBuilder attachment = new StringBuilder();
                for (Map.Entry<String, Object> entry : rpcInvocation.getObjectAttachments().entrySet()) {
                    attachment.append(entry.getKey()).append("=").append(entry.getValue()).append(";\n");
                }
                logger.warn(String.format("[Dubbo-Consumer] execute service %s#%s cost %d.%06d ms, this invocation almost (maybe already) timeout. Timeout: %dms\ninvocation context:\n%sthread info: \n%s", rpcInvocation.getProtocolServiceKey(), rpcInvocation.getMethodName(), usage / 1000000L, usage % 1000000L, timeout, attachment, Profiler.buildDetail(bizProfiler)));
            }
            return object;
        }
        return invoker.invoke(rpcInvocation).recreate();
    }
}

