/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import com.google.protobuf.ByteString;
import io.grpc.health.v1.HealthCheckResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.remoting.api.ConnectionManager;
import org.apache.dubbo.remoting.exchange.PortUnificationExchanger;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.StubServiceDescriptor;
import org.apache.dubbo.rpc.protocol.AbstractExporter;
import org.apache.dubbo.rpc.protocol.AbstractProtocol;
import org.apache.dubbo.rpc.protocol.tri.TripleInvoker;
import org.apache.dubbo.rpc.protocol.tri.compressor.DeCompressor;
import org.apache.dubbo.rpc.protocol.tri.service.TriBuiltinService;
import org.apache.dubbo.triple.TripleWrapper;

public class TripleProtocol
extends AbstractProtocol {
    public static final String METHOD_ATTR_PACK = "pack";
    private static final String CLIENT_THREAD_POOL_NAME = "DubboTriClientHandler";
    private static final URL THREAD_POOL_URL = new URL("tri", "127.0.0.1", 50051).addParameter("threadname", "DubboTriClientHandler").addParameterIfAbsent("threadpool", "cached");
    private static final Logger logger = LoggerFactory.getLogger(TripleProtocol.class);
    private final PathResolver pathResolver;
    private final TriBuiltinService triBuiltinService;
    private final ConnectionManager connectionManager;
    private final FrameworkModel frameworkModel;
    private final String acceptEncodings;
    private boolean versionChecked = false;

    public TripleProtocol(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.triBuiltinService = new TriBuiltinService(frameworkModel);
        this.pathResolver = frameworkModel.getExtensionLoader(PathResolver.class).getDefaultExtension();
        Set<String> supported = frameworkModel.getExtensionLoader(DeCompressor.class).getSupportedExtensions();
        this.acceptEncodings = String.join((CharSequence)",", supported);
        this.connectionManager = frameworkModel.getExtensionLoader(ConnectionManager.class).getExtension("multiple");
    }

    @Override
    public int getDefaultPort() {
        return 50051;
    }

    @Override
    public <T> Exporter<T> export(final Invoker<T> invoker) throws RpcException {
        final URL url = invoker.getUrl();
        this.checkProtobufVersion(url);
        final String key = TripleProtocol.serviceKey(url);
        AbstractExporter exporter = new AbstractExporter<T>(invoker){

            @Override
            public void afterUnExport() {
                TripleProtocol.this.pathResolver.remove(url.getServiceKey());
                TripleProtocol.this.pathResolver.add(url.getServiceModel().getServiceModel().getInterfaceName(), invoker);
                TripleProtocol.this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceKey(), HealthCheckResponse.ServingStatus.NOT_SERVING);
                TripleProtocol.this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceInterface(), HealthCheckResponse.ServingStatus.NOT_SERVING);
                TripleProtocol.this.exporterMap.remove(key);
            }
        };
        this.exporterMap.put(key, exporter);
        this.invokers.add(invoker);
        this.pathResolver.add(url.getServiceKey(), invoker);
        this.pathResolver.add(url.getServiceModel().getServiceModel().getInterfaceName(), invoker);
        this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceKey(), HealthCheckResponse.ServingStatus.SERVING);
        this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceInterface(), HealthCheckResponse.ServingStatus.SERVING);
        url.getOrDefaultApplicationModel().getExtensionLoader(ExecutorRepository.class).getDefaultExtension().createExecutorIfAbsent(url);
        PortUnificationExchanger.bind(invoker.getUrl());
        return exporter;
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        ExecutorService streamExecutor = this.getOrCreateStreamExecutor(url.getOrDefaultApplicationModel());
        TripleInvoker<T> invoker = new TripleInvoker<T>(type, url, this.acceptEncodings, this.connectionManager, this.invokers, streamExecutor);
        this.invokers.add(invoker);
        return invoker;
    }

    private ExecutorService getOrCreateStreamExecutor(ApplicationModel applicationModel) {
        ExecutorService executor = applicationModel.getExtensionLoader(ExecutorRepository.class).getDefaultExtension().createExecutorIfAbsent(THREAD_POOL_URL);
        Objects.requireNonNull(executor, String.format("No available executor found in %s", THREAD_POOL_URL));
        return executor;
    }

    @Override
    protected <T> Invoker<T> protocolBindingRefer(Class<T> type, URL url) throws RpcException {
        return null;
    }

    @Override
    public void destroy() {
        if (logger.isInfoEnabled()) {
            logger.info("Destroying protocol [" + this.getClass().getSimpleName() + "] ...");
        }
        PortUnificationExchanger.close();
        this.pathResolver.destroy();
        super.destroy();
    }

    private void checkProtobufVersion(URL url) {
        if (this.versionChecked) {
            return;
        }
        if (url.getServiceModel() == null) {
            return;
        }
        ServiceDescriptor descriptor = url.getServiceModel().getServiceModel();
        if (descriptor == null) {
            return;
        }
        if (descriptor instanceof StubServiceDescriptor) {
            return;
        }
        TripleWrapper.TripleResponseWrapper responseWrapper = TripleWrapper.TripleResponseWrapper.newBuilder().setData(ByteString.copyFromUtf8((String)"Test")).setSerializeType("Test").build();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            responseWrapper.writeTo(baos);
        }
        catch (IOException e) {
            throw new IllegalStateException("Bad protobuf-java version detected! Please make sure the version of user's classloader is greater than 3.11.0 ", e);
        }
        this.versionChecked = true;
    }
}

