/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.Parameters;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.ExchangeClient;
import org.apache.dubbo.remoting.exchange.ExchangeHandler;
import org.apache.dubbo.remoting.exchange.Exchangers;
import org.apache.dubbo.rpc.RpcException;

final class LazyConnectExchangeClient
implements ExchangeClient {
    private static final Logger logger = LoggerFactory.getLogger(LazyConnectExchangeClient.class);
    private final boolean requestWithWarning;
    private final URL url;
    private final ExchangeHandler requestHandler;
    private final Lock connectLock = new ReentrantLock();
    private final int warningPeriod = 5000;
    private final boolean needReconnect;
    private volatile ExchangeClient client;
    private final AtomicLong warningCount = new AtomicLong(0L);

    public LazyConnectExchangeClient(URL url, ExchangeHandler requestHandler) {
        this.url = url.addParameter("lazy", true);
        this.needReconnect = url.getParameter("send.reconnect", false);
        this.requestHandler = requestHandler;
        this.requestWithWarning = url.getParameter("lazyclient_request_with_warning", false);
    }

    private void initClient() throws RemotingException {
        if (this.client != null) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Lazy connect to " + this.url);
        }
        this.connectLock.lock();
        try {
            if (this.client != null) {
                return;
            }
            this.client = Exchangers.connect(this.url, this.requestHandler);
        }
        finally {
            this.connectLock.unlock();
        }
    }

    @Override
    public CompletableFuture<Object> request(Object request) throws RemotingException {
        this.warning();
        this.checkClient();
        return this.client.request(request);
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        if (this.client == null) {
            return InetSocketAddress.createUnresolved(this.url.getHost(), this.url.getPort());
        }
        return this.client.getRemoteAddress();
    }

    @Override
    public CompletableFuture<Object> request(Object request, int timeout) throws RemotingException {
        this.warning();
        this.checkClient();
        return this.client.request(request, timeout);
    }

    @Override
    public CompletableFuture<Object> request(Object request, ExecutorService executor) throws RemotingException {
        this.warning();
        this.checkClient();
        return this.client.request(request, executor);
    }

    @Override
    public CompletableFuture<Object> request(Object request, int timeout, ExecutorService executor) throws RemotingException {
        this.warning();
        this.checkClient();
        return this.client.request(request, timeout, executor);
    }

    private void warning() {
        if (this.requestWithWarning) {
            if (this.warningCount.get() % 5000L == 0L) {
                logger.warn(this.url.getAddress() + " " + this.url.getServiceKey() + " safe guard client , should not be called ,must have a bug.");
            }
            this.warningCount.incrementAndGet();
        }
    }

    @Override
    public ChannelHandler getChannelHandler() {
        this.checkClient();
        return this.client.getChannelHandler();
    }

    @Override
    public boolean isConnected() {
        if (this.client == null) {
            return true;
        }
        return this.client.isConnected();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        if (this.client == null) {
            return InetSocketAddress.createUnresolved(NetUtils.getLocalHost(), 0);
        }
        return this.client.getLocalAddress();
    }

    @Override
    public ExchangeHandler getExchangeHandler() {
        return this.requestHandler;
    }

    @Override
    public void send(Object message) throws RemotingException {
        this.checkClient();
        this.client.send(message);
    }

    @Override
    public void send(Object message, boolean sent) throws RemotingException {
        this.checkClient();
        this.client.send(message, sent);
    }

    @Override
    public boolean isClosed() {
        if (this.client != null) {
            return this.client.isClosed();
        }
        return false;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    @Override
    public void close(int timeout) {
        if (this.client != null) {
            this.client.close(timeout);
            this.client = null;
        }
    }

    @Override
    public void startClose() {
        if (this.client != null) {
            this.client.startClose();
        }
    }

    @Override
    public void reset(URL url) {
        this.checkClient();
        this.client.reset(url);
    }

    @Override
    @Deprecated
    public void reset(Parameters parameters) {
        this.reset(this.getUrl().addParameters(parameters.getParameters()));
    }

    @Override
    public void reconnect() throws RemotingException {
        this.checkClient();
        this.client.reconnect();
    }

    @Override
    public Object getAttribute(String key) {
        if (this.client == null) {
            return null;
        }
        return this.client.getAttribute(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.checkClient();
        this.client.setAttribute(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        this.checkClient();
        this.client.removeAttribute(key);
    }

    @Override
    public boolean hasAttribute(String key) {
        if (this.client == null) {
            return false;
        }
        return this.client.hasAttribute(key);
    }

    private void checkClient() {
        try {
            this.initClient();
        }
        catch (Exception e) {
            throw new RpcException("Fail to create remoting client for service(" + this.url + "): " + e.getMessage(), (Throwable)e);
        }
        if (!this.isConnected() && !this.needReconnect) {
            throw new IllegalStateException("LazyConnectExchangeClient is not connected normally, and send.reconnect is configured as false, the request fails quickly" + this.url);
        }
    }
}

