/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.Codec2;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.remoting.transport.ExceedPayloadLimitException;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

public abstract class AbstractCodec
implements Codec2,
ScopeModelAware {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCodec.class);
    private static final String CLIENT_SIDE = "client";
    private static final String SERVER_SIDE = "server";
    protected FrameworkModel frameworkModel;

    @Override
    public void setFrameworkModel(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    protected static void checkPayload(Channel channel, long size) throws IOException {
        int payload = AbstractCodec.getPayload(channel);
        boolean overPayload = AbstractCodec.isOverPayload(payload, size);
        if (overPayload) {
            ExceedPayloadLimitException e = new ExceedPayloadLimitException("Data length too large: " + size + ", max payload: " + payload + ", channel: " + channel);
            logger.error(e);
            throw e;
        }
    }

    protected static int getPayload(Channel channel) {
        int payload = 0x800000;
        if (channel != null && channel.getUrl() != null) {
            payload = channel.getUrl().getParameter("payload", 0x800000);
        }
        return payload;
    }

    protected static boolean isOverPayload(int payload, long size) {
        return payload > 0 && size > (long)payload;
    }

    protected Serialization getSerialization(Channel channel, Request req) {
        return CodecSupport.getSerialization(channel.getUrl());
    }

    protected Serialization getSerialization(Channel channel, Response res) {
        return CodecSupport.getSerialization(channel.getUrl());
    }

    protected Serialization getSerialization(Channel channel) {
        return CodecSupport.getSerialization(channel.getUrl());
    }

    protected boolean isClientSide(Channel channel) {
        String side = (String)channel.getAttribute("side");
        if (CLIENT_SIDE.equals(side)) {
            return true;
        }
        if (SERVER_SIDE.equals(side)) {
            return false;
        }
        InetSocketAddress address = channel.getRemoteAddress();
        URL url = channel.getUrl();
        boolean isClient = url.getPort() == address.getPort() && NetUtils.filterLocalHost(url.getIp()).equals(NetUtils.filterLocalHost(address.getAddress().getHostAddress()));
        channel.setAttribute("side", isClient ? CLIENT_SIDE : SERVER_SIDE);
        return isClient;
    }

    protected boolean isServerSide(Channel channel) {
        return !this.isClientSide(channel);
    }
}

