/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.enums.ConfigSourceType;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;

public class ApolloDynamicConfiguration
implements DynamicConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ApolloDynamicConfiguration.class);
    private static final String APOLLO_ENV_KEY = "env";
    private static final String APOLLO_ADDR_KEY = "apollo.meta";
    private static final String APOLLO_CLUSTER_KEY = "apollo.cluster";
    private static final String APOLLO_PROTOCOL_PREFIX = "http://";
    private static final String APOLLO_APPLICATION_KEY = "application";
    private static final String APOLLO_APPID_KEY = "app.id";
    private final URL url;
    private final Config dubboConfig;
    private final ConfigFile dubboConfigFile;
    private final ConcurrentMap<String, ApolloListener> listeners = new ConcurrentHashMap<String, ApolloListener>();

    ApolloDynamicConfiguration(URL url) {
        String namespace;
        this.url = url;
        String configEnv = url.getParameter(APOLLO_ENV_KEY);
        String configAddr = this.getAddressWithProtocolPrefix(url);
        String configCluster = url.getParameter("cluster");
        String configAppId = url.getParameter(APOLLO_APPID_KEY);
        if (StringUtils.isEmpty(System.getProperty(APOLLO_ENV_KEY)) && configEnv != null) {
            System.setProperty(APOLLO_ENV_KEY, configEnv);
        }
        if (StringUtils.isEmpty(System.getProperty(APOLLO_ADDR_KEY)) && !"0.0.0.0".equals(url.getHost())) {
            System.setProperty(APOLLO_ADDR_KEY, configAddr);
        }
        if (StringUtils.isEmpty(System.getProperty(APOLLO_CLUSTER_KEY)) && configCluster != null) {
            System.setProperty(APOLLO_CLUSTER_KEY, configCluster);
        }
        if (StringUtils.isEmpty(System.getProperty(APOLLO_APPID_KEY)) && configAppId != null) {
            System.setProperty(APOLLO_APPID_KEY, configAppId);
        }
        String apolloNamespace = StringUtils.isEmpty(namespace = url.getParameter("namespace", "dubbo")) ? url.getGroup("dubbo") : namespace;
        this.dubboConfig = ConfigService.getConfig((String)apolloNamespace);
        this.dubboConfigFile = ConfigService.getConfigFile((String)apolloNamespace, (ConfigFileFormat)ConfigFileFormat.Properties);
        boolean check = url.getParameter("check", true);
        if (this.dubboConfig.getSourceType() != ConfigSourceType.REMOTE) {
            if (check) {
                throw new IllegalStateException("Failed to connect to config center, the config center is Apollo, the address is: " + (StringUtils.isNotEmpty(configAddr) ? configAddr : configEnv));
            }
            logger.warn("Failed to connect to config center, the config center is Apollo, the address is: " + (StringUtils.isNotEmpty(configAddr) ? configAddr : configEnv) + ", will use the local cache value instead before eventually the connection is established.");
        }
    }

    @Override
    public void close() {
        try {
            this.listeners.clear();
        }
        catch (UnsupportedOperationException e) {
            logger.warn("Failed to close connect from config center, the config center is Apollo");
        }
    }

    private String getAddressWithProtocolPrefix(URL url) {
        String address = url.getBackupAddress();
        if (StringUtils.isNotEmpty(address)) {
            address = Arrays.stream(CommonConstants.COMMA_SPLIT_PATTERN.split(address)).map(addr -> {
                if (addr.startsWith(APOLLO_PROTOCOL_PREFIX)) {
                    return addr;
                }
                return APOLLO_PROTOCOL_PREFIX + addr;
            }).collect(Collectors.joining(","));
        }
        return address;
    }

    @Override
    public void addListener(String key, String group, ConfigurationListener listener) {
        ApolloListener apolloListener = this.listeners.computeIfAbsent(group + key, k -> this.createTargetListener(key, group));
        apolloListener.addListener(listener);
        this.dubboConfig.addChangeListener((ConfigChangeListener)apolloListener, Collections.singleton(key));
    }

    @Override
    public void removeListener(String key, String group, ConfigurationListener listener) {
        ApolloListener apolloListener = (ApolloListener)this.listeners.get(group + key);
        if (apolloListener != null) {
            apolloListener.removeListener(listener);
            if (!apolloListener.hasInternalListener()) {
                this.dubboConfig.removeChangeListener((ConfigChangeListener)apolloListener);
            }
        }
    }

    @Override
    public String getConfig(String key, String group, long timeout) throws IllegalStateException {
        if (StringUtils.isNotEmpty(group)) {
            if (group.equals(this.url.getApplication())) {
                return ConfigService.getAppConfig().getProperty(key, null);
            }
            return ConfigService.getConfig((String)group).getProperty(key, null);
        }
        return this.dubboConfig.getProperty(key, null);
    }

    @Override
    public String getProperties(String key, String group, long timeout) throws IllegalStateException {
        if (StringUtils.isEmpty(group)) {
            return this.dubboConfigFile.getContent();
        }
        if (group.equals(this.url.getApplication())) {
            return ConfigService.getConfigFile((String)APOLLO_APPLICATION_KEY, (ConfigFileFormat)ConfigFileFormat.Properties).getContent();
        }
        ConfigFile configFile = ConfigService.getConfigFile((String)group, (ConfigFileFormat)ConfigFileFormat.Properties);
        if (configFile == null) {
            throw new IllegalStateException("There is no namespace named " + group + " in Apollo.");
        }
        return configFile.getContent();
    }

    @Override
    public String getInternalProperty(String key) {
        return this.dubboConfig.getProperty(key, null);
    }

    private ApolloListener createTargetListener(String key, String group) {
        return new ApolloListener();
    }

    public class ApolloListener
    implements ConfigChangeListener {
        private Set<ConfigurationListener> listeners = new CopyOnWriteArraySet<ConfigurationListener>();

        ApolloListener() {
        }

        public void onChange(ConfigChangeEvent changeEvent) {
            for (String key : changeEvent.changedKeys()) {
                ConfigChange change = changeEvent.getChange(key);
                if ("".equals(change.getNewValue())) {
                    logger.warn("an empty rule is received for " + key + ", the current working rule is " + change.getOldValue() + ", the empty rule will not take effect.");
                    return;
                }
                ConfigChangedEvent event = new ConfigChangedEvent(key, change.getNamespace(), change.getNewValue(), this.getChangeType(change));
                this.listeners.forEach(listener -> listener.process(event));
            }
        }

        private ConfigChangeType getChangeType(ConfigChange change) {
            if (change.getChangeType() == PropertyChangeType.DELETED) {
                return ConfigChangeType.DELETED;
            }
            return ConfigChangeType.MODIFIED;
        }

        void addListener(ConfigurationListener configurationListener) {
            this.listeners.add(configurationListener);
        }

        void removeListener(ConfigurationListener configurationListener) {
            this.listeners.remove(configurationListener);
        }

        boolean hasInternalListener() {
            return this.listeners != null && this.listeners.size() > 0;
        }
    }
}

