/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.proxy.javassist;

import java.util.Arrays;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.bytecode.Proxy;
import org.apache.dubbo.common.bytecode.Wrapper;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.proxy.AbstractProxyFactory;
import org.apache.dubbo.rpc.proxy.AbstractProxyInvoker;
import org.apache.dubbo.rpc.proxy.InvokerInvocationHandler;
import org.apache.dubbo.rpc.proxy.jdk.JdkProxyFactory;

public class JavassistProxyFactory
extends AbstractProxyFactory {
    private static final Logger logger = LoggerFactory.getLogger(JavassistProxyFactory.class);
    private final JdkProxyFactory jdkProxyFactory = new JdkProxyFactory();

    @Override
    public <T> T getProxy(Invoker<T> invoker, Class<?>[] interfaces) {
        try {
            return (T)Proxy.getProxy(interfaces).newInstance(new InvokerInvocationHandler(invoker));
        }
        catch (Throwable fromJavassist) {
            try {
                T proxy = this.jdkProxyFactory.getProxy(invoker, interfaces);
                logger.error("Failed to generate proxy by Javassist failed. Fallback to use JDK proxy success. Interfaces: " + Arrays.toString(interfaces), fromJavassist);
                return proxy;
            }
            catch (Throwable fromJdk) {
                logger.error("Failed to generate proxy by Javassist failed. Fallback to use JDK proxy is also failed. Interfaces: " + Arrays.toString(interfaces) + " Javassist Error.", fromJavassist);
                logger.error("Failed to generate proxy by Javassist failed. Fallback to use JDK proxy is also failed. Interfaces: " + Arrays.toString(interfaces) + " JDK Error.", fromJdk);
                throw fromJavassist;
            }
        }
    }

    @Override
    public <T> Invoker<T> getInvoker(T proxy, Class<T> type, URL url) {
        try {
            final Wrapper wrapper = Wrapper.getWrapper(proxy.getClass().getName().indexOf(36) < 0 ? proxy.getClass() : type);
            return new AbstractProxyInvoker<T>(proxy, type, url){

                @Override
                protected Object doInvoke(T proxy, String methodName, Class<?>[] parameterTypes, Object[] arguments) throws Throwable {
                    return wrapper.invokeMethod(proxy, methodName, parameterTypes, arguments);
                }
            };
        }
        catch (Throwable fromJavassist) {
            try {
                Invoker<T> invoker = this.jdkProxyFactory.getInvoker(proxy, type, url);
                logger.error("Failed to generate invoker by Javassist failed. Fallback to use JDK proxy success. Interfaces: " + type, fromJavassist);
                return invoker;
            }
            catch (Throwable fromJdk) {
                logger.error("Failed to generate invoker by Javassist failed. Fallback to use JDK proxy is also failed. Interfaces: " + type + " Javassist Error.", fromJavassist);
                logger.error("Failed to generate invoker by Javassist failed. Fallback to use JDK proxy is also failed. Interfaces: " + type + " JDK Error.", fromJdk);
                throw fromJavassist;
            }
        }
    }
}

