/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.compressor.DeCompressor;
import org.apache.dubbo.rpc.protocol.tri.stream.ServerStream;

public class TripleHttp2FrameServerHandler
extends ChannelDuplexHandler {
    private static final AttributeKey<ServerStream> SERVER_STREAM_KEY = AttributeKey.valueOf((String)"tri_server_stream");
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleHttp2FrameServerHandler.class);
    private final PathResolver pathResolver;
    private final FrameworkModel frameworkModel;
    private final Executor executor;
    private final List<HeaderFilter> filters;
    private final String acceptEncoding;

    public TripleHttp2FrameServerHandler(FrameworkModel frameworkModel, Executor executor, List<HeaderFilter> filters) {
        this.frameworkModel = frameworkModel;
        this.executor = executor;
        this.filters = filters;
        this.acceptEncoding = String.join((CharSequence)",", frameworkModel.getExtensionLoader(DeCompressor.class).getSupportedExtensions());
        this.pathResolver = frameworkModel.getExtensionLoader(PathResolver.class).getDefaultExtension();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            this.onHeadersRead(ctx, (Http2HeadersFrame)msg);
        } else if (msg instanceof Http2DataFrame) {
            this.onDataRead(ctx, (Http2DataFrame)msg);
        } else if (msg instanceof ReferenceCounted) {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof Http2ResetFrame) {
            this.onResetRead(ctx, (Http2ResetFrame)evt);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void onResetRead(ChannelHandlerContext ctx, Http2ResetFrame frame) {
        ServerStream serverStream = (ServerStream)ctx.channel().attr(SERVER_STREAM_KEY).get();
        LOGGER.warn("Triple Server received remote reset errorCode=" + frame.errorCode());
        if (serverStream != null) {
            serverStream.transportObserver.cancelByRemote(TriRpcStatus.CANCELLED.withDescription("Cancel by remote peer, err_code=" + frame.errorCode()));
        }
        ctx.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Exception in processing triple message", cause);
        }
        TriRpcStatus status = TriRpcStatus.getStatus(cause, "Provider's error:\n" + cause.getMessage());
        ServerStream serverStream = (ServerStream)ctx.channel().attr(SERVER_STREAM_KEY).get();
        if (serverStream != null) {
            serverStream.close(status, null);
        }
    }

    public void onDataRead(ChannelHandlerContext ctx, Http2DataFrame msg) throws Exception {
        ServerStream serverStream = (ServerStream)ctx.channel().attr(SERVER_STREAM_KEY).get();
        serverStream.transportObserver.onData(msg.content(), msg.isEndStream());
    }

    public void onHeadersRead(ChannelHandlerContext ctx, Http2HeadersFrame msg) throws Exception {
        ServerStream serverStream = new ServerStream(ctx.channel(), this.frameworkModel, this.executor, this.pathResolver, this.acceptEncoding, this.filters);
        ctx.channel().attr(SERVER_STREAM_KEY).set((Object)serverStream);
        serverStream.transportObserver.onHeader(msg.headers(), msg.isEndStream());
    }
}

