/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.service;

import io.grpc.health.v1.Health;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.service.HealthStatusManager;
import org.apache.dubbo.rpc.protocol.tri.service.TriHealthImpl;

public class TriBuiltinService {
    private final ProxyFactory proxyFactory;
    private final PathResolver pathResolver;
    private final Health healthService;
    private final HealthStatusManager healthStatusManager;
    private final AtomicBoolean init = new AtomicBoolean();

    public TriBuiltinService(FrameworkModel frameworkModel) {
        this.healthStatusManager = new HealthStatusManager(new TriHealthImpl());
        this.healthService = this.healthStatusManager.getHealthService();
        this.proxyFactory = frameworkModel.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
        this.pathResolver = frameworkModel.getExtensionLoader(PathResolver.class).getDefaultExtension();
        this.init();
    }

    public void init() {
        if (this.init.compareAndSet(false, true)) {
            URL url = new ServiceConfigURL("tri", null, null, "0.0.0.0", 0, "grpc.health.v1.Health").addParameter("proxy", "nativestub").setScopeModel(ApplicationModel.defaultModel().getInternalModule());
            Invoker<Health> invoker = this.proxyFactory.getInvoker(this.healthService, Health.class, url);
            this.pathResolver.add("grpc.health.v1.Health", invoker);
            ApplicationModel.defaultModel().getInternalModule().addDestroyListener(scopeModel -> this.pathResolver.remove("grpc.health.v1.Health"));
        }
    }

    public HealthStatusManager getHealthStatusManager() {
        return this.healthStatusManager;
    }
}

