/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.call;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.serial.SerializingExecutor;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.CancellationContext;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.PackableMethod;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.tri.ClassLoadUtil;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.call.AbstractServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.call.BiStreamServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.call.ServerStreamServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.call.UnaryServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.compressor.Compressor;
import org.apache.dubbo.rpc.protocol.tri.observer.ServerCallToObserverAdapter;
import org.apache.dubbo.rpc.protocol.tri.stream.ServerStream;
import org.apache.dubbo.rpc.protocol.tri.stream.ServerStreamListener;
import org.apache.dubbo.rpc.protocol.tri.stream.StreamUtils;

public abstract class ServerCall {
    public static final String REMOTE_ADDRESS_KEY = "tri.remote.address";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerCall.class);
    public final Invoker<?> invoker;
    public final FrameworkModel frameworkModel;
    public final ServerStream serverStream;
    public final Executor executor;
    public final String methodName;
    public final String serviceName;
    public final ServiceDescriptor serviceDescriptor;
    private final String acceptEncoding;
    public boolean autoRequestN = true;
    public Long timeout;
    Listener listener;
    private Compressor compressor;
    private boolean headerSent;
    private boolean closed;
    protected PackableMethod packableMethod;

    ServerCall(Invoker<?> invoker, ServerStream serverStream, FrameworkModel frameworkModel, ServiceDescriptor serviceDescriptor, String acceptEncoding, String serviceName, String methodName, Executor executor) {
        this.invoker = invoker;
        this.executor = new SerializingExecutor(executor);
        this.frameworkModel = frameworkModel;
        this.serviceDescriptor = serviceDescriptor;
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.serverStream = serverStream;
        this.acceptEncoding = acceptEncoding;
    }

    protected abstract ServerStreamListener doStartCall(Map<String, Object> var1);

    protected RpcInvocation buildInvocation(Map<String, Object> headers, MethodDescriptor methodDescriptor) {
        URL url = this.invoker.getUrl();
        RpcInvocation inv = new RpcInvocation(url.getServiceModel(), methodDescriptor.getMethodName(), this.serviceDescriptor.getInterfaceName(), url.getProtocolServiceKey(), methodDescriptor.getParameterClasses(), new Object[0]);
        inv.setTargetServiceUniqueName(url.getServiceKey());
        inv.setReturnTypes(methodDescriptor.getReturnTypes());
        inv.setObjectAttachments(StreamUtils.toAttachments(headers));
        inv.put(REMOTE_ADDRESS_KEY, this.serverStream.remoteAddress());
        if (null != headers.get(TripleHeaderEnum.CONSUMER_APP_NAME_KEY.getHeader())) {
            inv.put((Object)TripleHeaderEnum.CONSUMER_APP_NAME_KEY, headers.get(TripleHeaderEnum.CONSUMER_APP_NAME_KEY.getHeader()));
        }
        return inv;
    }

    public ServerStreamListener startCall(Map<String, Object> metadata) {
        if (this.serviceDescriptor == null) {
            this.responseErr(TriRpcStatus.UNIMPLEMENTED.withDescription("Service not found:" + this.serviceName));
            return null;
        }
        String timeout = (String)metadata.get(TripleHeaderEnum.TIMEOUT.getHeader());
        try {
            if (Objects.nonNull(timeout)) {
                this.timeout = this.parseTimeoutToMills(timeout);
            }
        }
        catch (Throwable t) {
            LOGGER.warn(String.format("Failed to parse request timeout set from:%s, service=%s method=%s", timeout, this.serviceDescriptor.getInterfaceName(), this.methodName));
        }
        return this.doStartCall(metadata);
    }

    private void sendHeader() {
        if (this.headerSent) {
            throw new IllegalStateException("Header has already sent");
        }
        this.headerSent = true;
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.status((CharSequence)HttpResponseStatus.OK.codeAsText());
        headers.set((Object)HttpHeaderNames.CONTENT_TYPE, (Object)"application/grpc+proto");
        if (this.acceptEncoding != null) {
            headers.set((Object)HttpHeaderNames.ACCEPT_ENCODING, (Object)this.acceptEncoding);
        }
        if (this.compressor != null) {
            headers.set((Object)TripleHeaderEnum.GRPC_ENCODING.getHeader(), (Object)this.compressor.getMessageEncoding());
        }
        this.serverStream.sendHeader((Http2Headers)headers);
    }

    public void requestN(int n) {
        this.serverStream.requestN(n);
    }

    public void setCompression(String compression) {
        if (this.headerSent) {
            throw new IllegalStateException("Can not set compression after header sent");
        }
        this.compressor = Compressor.getCompressor(this.frameworkModel, compression);
    }

    public void disableAutoRequestN() {
        this.autoRequestN = false;
    }

    public boolean isAutoRequestN() {
        return this.autoRequestN;
    }

    public void writeMessage(Object message) {
        Runnable writeMessage = () -> this.doWriteMessage(message);
        this.executor.execute(writeMessage);
    }

    private void doWriteMessage(Object message) {
        byte[] data;
        if (this.closed) {
            return;
        }
        if (!this.headerSent) {
            this.sendHeader();
        }
        try {
            data = this.packableMethod.packResponse(message);
        }
        catch (IOException e) {
            this.close(TriRpcStatus.INTERNAL.withDescription("Serialize response failed").withCause(e), null);
            return;
        }
        if (data == null) {
            this.close(TriRpcStatus.INTERNAL.withDescription("Missing response"), null);
            return;
        }
        if (this.compressor != null) {
            int compressedFlag = "identity".equals(this.compressor.getMessageEncoding()) ? 0 : 1;
            byte[] compressed = this.compressor.compress(data);
            this.serverStream.writeMessage(compressed, compressedFlag);
        } else {
            this.serverStream.writeMessage(data, 0);
        }
    }

    public void close(TriRpcStatus status, Map<String, Object> trailers) {
        this.executor.execute(() -> this.serverStream.close(status, trailers));
    }

    protected Long parseTimeoutToMills(String timeoutVal) {
        if (StringUtils.isEmpty(timeoutVal) || StringUtils.isContains(timeoutVal, "null")) {
            return null;
        }
        long value = Long.parseLong(timeoutVal.substring(0, timeoutVal.length() - 1));
        char unit = timeoutVal.charAt(timeoutVal.length() - 1);
        switch (unit) {
            case 'n': {
                return TimeUnit.NANOSECONDS.toMillis(value);
            }
            case 'u': {
                return TimeUnit.MICROSECONDS.toMillis(value);
            }
            case 'm': {
                return value;
            }
            case 'S': {
                return TimeUnit.SECONDS.toMillis(value);
            }
            case 'M': {
                return TimeUnit.MINUTES.toMillis(value);
            }
            case 'H': {
                return TimeUnit.HOURS.toMillis(value);
            }
        }
        return null;
    }

    protected void responseErr(TriRpcStatus status) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Http2Headers trailers = (Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.OK.codeAsText()).set((Object)HttpHeaderNames.CONTENT_TYPE, (Object)"application/grpc+proto")).setInt((Object)TripleHeaderEnum.STATUS_KEY.getHeader(), status.code.code)).set((Object)TripleHeaderEnum.MESSAGE_KEY.getHeader(), (Object)status.toEncodedMessage());
        this.serverStream.sendHeaderWithEos(trailers);
        LOGGER.error("Triple request error: service=" + this.serviceName + " method" + this.methodName, status.asException());
    }

    protected Listener startInternalCall(RpcInvocation invocation, MethodDescriptor methodDescriptor, Invoker<?> invoker) {
        CancellationContext cancellationContext = RpcContext.getCancellationContext();
        ServerCallToObserverAdapter<Object> responseObserver = new ServerCallToObserverAdapter<Object>(this, cancellationContext);
        try {
            AbstractServerCallListener listener;
            switch (methodDescriptor.getRpcType()) {
                case UNARY: {
                    listener = new UnaryServerCallListener(invocation, invoker, responseObserver);
                    this.requestN(2);
                    break;
                }
                case SERVER_STREAM: {
                    listener = new ServerStreamServerCallListener(invocation, invoker, responseObserver);
                    this.requestN(2);
                    break;
                }
                case BI_STREAM: 
                case CLIENT_STREAM: {
                    listener = new BiStreamServerCallListener(invocation, invoker, responseObserver);
                    this.requestN(1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Can not reach here");
                }
            }
            return listener;
        }
        catch (Throwable t) {
            LOGGER.error("Create triple stream failed", t);
            responseObserver.onError(TriRpcStatus.INTERNAL.withDescription("Create stream failed").withCause(t).asException());
            return null;
        }
    }

    abstract class ServerStreamListenerBase
    implements ServerStreamListener {
        protected boolean closed;

        ServerStreamListenerBase() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(byte[] message) {
            if (this.closed) {
                return;
            }
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                this.doOnMessage(message);
            }
            catch (Throwable t) {
                TriRpcStatus status = TriRpcStatus.INTERNAL.withDescription("Server error").withCause(t);
                ServerCall.this.close(status, null);
                LOGGER.error("Process request failed. service=" + ServerCall.this.serviceName + " method=" + ServerCall.this.methodName, t);
            }
            finally {
                ClassLoadUtil.switchContextLoader(tccl);
            }
        }

        protected abstract void doOnMessage(byte[] var1) throws IOException, ClassNotFoundException;
    }

    static interface Listener {
        public void onMessage(Object var1);

        public void onCancel(String var1);

        public void onComplete();
    }
}

