/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.call;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.tri.ClassLoadUtil;
import org.apache.dubbo.rpc.protocol.tri.ReflectionPackableMethod;
import org.apache.dubbo.rpc.protocol.tri.call.ServerCall;
import org.apache.dubbo.rpc.protocol.tri.stream.ServerStream;
import org.apache.dubbo.rpc.protocol.tri.stream.ServerStreamListener;
import org.apache.dubbo.rpc.service.ServiceDescriptorInternalCache;
import org.apache.dubbo.triple.TripleWrapper;

public class ReflectionServerCall
extends ServerCall {
    private final List<HeaderFilter> headerFilters;
    private MethodDescriptor methodDescriptor;
    private List<MethodDescriptor> methodDescriptors;
    private RpcInvocation invocation;

    public ReflectionServerCall(Invoker<?> invoker, ServerStream serverStream, FrameworkModel frameworkModel, String acceptEncoding, String serviceName, String methodName, List<HeaderFilter> headerFilters, Executor executor) {
        super(invoker, serverStream, frameworkModel, ReflectionServerCall.getServiceDescriptor(invoker.getUrl()), acceptEncoding, serviceName, methodName, executor);
        this.headerFilters = headerFilters;
    }

    private static ServiceDescriptor getServiceDescriptor(URL url) {
        ProviderModel providerModel = (ProviderModel)url.getServiceModel();
        if (providerModel == null || providerModel.getServiceModel() == null) {
            return null;
        }
        return providerModel.getServiceModel();
    }

    private boolean isEcho(String methodName) {
        return "$echo".equals(methodName);
    }

    private boolean isGeneric(String methodName) {
        return "$invoke".equals(methodName) || "$invokeAsync".equals(methodName);
    }

    @Override
    public ServerStreamListener doStartCall(Map<String, Object> metadata) {
        if (this.isGeneric(this.methodName)) {
            this.methodDescriptor = ServiceDescriptorInternalCache.genericService().getMethods(this.methodName).get(0);
        } else if (this.isEcho(this.methodName)) {
            this.methodDescriptor = ServiceDescriptorInternalCache.echoService().getMethods(this.methodName).get(0);
        } else {
            this.methodDescriptors = this.serviceDescriptor.getMethods(this.methodName);
            if (CollectionUtils.isEmpty(this.methodDescriptors)) {
                String lowerMethod = Character.toLowerCase(this.methodName.charAt(0)) + this.methodName.substring(1);
                this.methodDescriptors = this.serviceDescriptor.getMethods(lowerMethod);
            }
            if (CollectionUtils.isEmpty(this.methodDescriptors)) {
                this.responseErr(TriRpcStatus.UNIMPLEMENTED.withDescription("Method : " + this.methodName + " not found of service:" + this.serviceName));
                return null;
            }
            if (this.methodDescriptors.size() == 1) {
                this.methodDescriptor = this.methodDescriptors.get(0);
            }
            if (this.methodDescriptors.size() == 2) {
                if (this.methodDescriptors.get(1).getRpcType() == MethodDescriptor.RpcType.SERVER_STREAM) {
                    this.methodDescriptor = this.methodDescriptors.get(0);
                } else if (this.methodDescriptors.get(0).getRpcType() == MethodDescriptor.RpcType.SERVER_STREAM) {
                    this.methodDescriptor = this.methodDescriptors.get(1);
                }
            }
        }
        if (this.methodDescriptor != null) {
            this.packableMethod = ReflectionPackableMethod.init(this.methodDescriptor, this.invoker.getUrl());
        }
        ServerStreamListenerImpl listener = new ServerStreamListenerImpl();
        listener.startCall(metadata);
        return listener;
    }

    class ServerStreamListenerImpl
    extends ServerCall.ServerStreamListenerBase {
        private Map<String, Object> metadata;

        ServerStreamListenerImpl() {
            super(ReflectionServerCall.this);
        }

        void startCall(Map<String, Object> metadata) {
            this.metadata = metadata;
            this.trySetListener();
            if (ReflectionServerCall.this.listener == null) {
                ReflectionServerCall.this.requestN(1);
            }
        }

        @Override
        public void complete() {
            if (ReflectionServerCall.this.listener != null) {
                ReflectionServerCall.this.listener.onComplete();
            }
        }

        @Override
        public void cancel(TriRpcStatus status) {
            ReflectionServerCall.this.listener.onCancel(status.description);
        }

        @Override
        protected void doOnMessage(byte[] message) throws IOException, ClassNotFoundException {
            this.trySetMethodDescriptor(message);
            this.trySetListener();
            if (this.closed) {
                return;
            }
            if (ReflectionServerCall.this.serviceDescriptor != null) {
                ClassLoadUtil.switchContextLoader(ReflectionServerCall.this.serviceDescriptor.getServiceInterfaceClass().getClassLoader());
            }
            Object obj = ReflectionServerCall.this.packableMethod.getRequestUnpack().unpack(message);
            ReflectionServerCall.this.listener.onMessage(obj);
        }

        private void trySetMethodDescriptor(byte[] data) throws IOException {
            if (ReflectionServerCall.this.methodDescriptor != null) {
                return;
            }
            TripleWrapper.TripleRequestWrapper request = TripleWrapper.TripleRequestWrapper.parseFrom(data);
            Object[] paramTypes = (String[])request.getArgTypesList().toArray((Object[])new String[request.getArgsCount()]);
            for (MethodDescriptor descriptor : ReflectionServerCall.this.methodDescriptors) {
                if (!Arrays.equals(descriptor.getCompatibleParamSignatures(), paramTypes)) continue;
                ReflectionServerCall.this.methodDescriptor = descriptor;
                break;
            }
            if (ReflectionServerCall.this.methodDescriptor == null) {
                ReflectionServerCall.this.close(TriRpcStatus.UNIMPLEMENTED.withDescription("Method :" + ReflectionServerCall.this.methodName + "[" + Arrays.toString(paramTypes) + "] not found of service:" + ReflectionServerCall.this.serviceDescriptor.getInterfaceName()), null);
                return;
            }
            ReflectionServerCall.this.packableMethod = ReflectionPackableMethod.init(ReflectionServerCall.this.methodDescriptor, ReflectionServerCall.this.invoker.getUrl());
        }

        private void trySetListener() {
            if (ReflectionServerCall.this.listener != null) {
                return;
            }
            if (ReflectionServerCall.this.methodDescriptor == null) {
                return;
            }
            if (this.closed) {
                return;
            }
            ReflectionServerCall.this.invocation = ReflectionServerCall.this.buildInvocation(this.metadata, ReflectionServerCall.this.methodDescriptor);
            if (this.closed) {
                return;
            }
            ReflectionServerCall.this.headerFilters.forEach(f -> f.invoke(ReflectionServerCall.this.invoker, ReflectionServerCall.this.invocation));
            if (this.closed) {
                return;
            }
            ReflectionServerCall.this.listener = ReflectionServerCall.this.startInternalCall(ReflectionServerCall.this.invocation, ReflectionServerCall.this.methodDescriptor, ReflectionServerCall.this.invoker);
            if (ReflectionServerCall.this.listener == null) {
                this.closed = true;
            }
        }
    }
}

