/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.call;

import com.google.protobuf.Any;
import com.google.rpc.DebugInfo;
import com.google.rpc.ErrorInfo;
import com.google.rpc.Status;
import io.netty.handler.codec.http2.Http2Headers;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.remoting.api.Connection;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.PackableMethod;
import org.apache.dubbo.rpc.protocol.tri.ClassLoadUtil;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.RequestMetadata;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.compressor.Compressor;
import org.apache.dubbo.rpc.protocol.tri.observer.ClientCallToObserverAdapter;
import org.apache.dubbo.rpc.protocol.tri.stream.ClientStream;
import org.apache.dubbo.rpc.protocol.tri.stream.ClientStreamListener;
import org.apache.dubbo.rpc.protocol.tri.stream.StreamUtils;

public class ClientCall {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientCall.class);
    private final Connection connection;
    private final Executor executor;
    private final FrameworkModel frameworkModel;
    private RequestMetadata requestMetadata;
    private ClientStream stream;
    private Listener listener;
    private boolean canceled;
    private boolean headerSent;
    private boolean autoRequestN = true;

    public ClientCall(Connection connection, Executor executor, FrameworkModel frameworkModel) {
        this.connection = connection;
        this.executor = executor;
        this.frameworkModel = frameworkModel;
    }

    public void sendMessage(Object message) {
        if (this.canceled) {
            throw new IllegalStateException("Call already canceled");
        }
        if (!this.headerSent) {
            this.headerSent = true;
            this.stream.sendHeader((Http2Headers)this.requestMetadata.toHeaders());
        }
        try {
            byte[] data = this.requestMetadata.packableMethod.packRequest(message);
            int compressed = "identity".equals(this.requestMetadata.compressor.getMessageEncoding()) ? 0 : 1;
            byte[] compress = this.requestMetadata.compressor.compress(data);
            this.stream.writeMessage(compress, compressed);
        }
        catch (Throwable t) {
            LOGGER.error(String.format("Serialize triple request failed, service=%s method=%s", this.requestMetadata.service, this.requestMetadata.method), t);
            this.cancel("Serialize request failed", t);
            this.listener.onClose(TriRpcStatus.INTERNAL.withDescription("Serialize request failed").withCause(t), null);
        }
    }

    public void requestN(int n) {
        this.stream.requestN(n);
    }

    public void halfClose() {
        if (!this.headerSent) {
            return;
        }
        if (this.canceled) {
            return;
        }
        this.stream.halfClose();
    }

    public void setCompression(String compression) {
        this.requestMetadata.compressor = Compressor.getCompressor(this.frameworkModel, compression);
    }

    public StreamObserver<Object> start(RequestMetadata metadata, Listener responseListener) {
        this.requestMetadata = metadata;
        this.listener = responseListener;
        this.stream = new ClientStream(this.frameworkModel, this.executor, this.connection.getChannel(), (ClientStreamListener)new ClientStreamListenerImpl(responseListener, metadata.packableMethod));
        return new ClientCallToObserverAdapter<Object>(this);
    }

    public void cancel(String message, Throwable t) {
        if (this.canceled) {
            return;
        }
        if (!this.headerSent) {
            return;
        }
        this.canceled = true;
        if (this.stream == null) {
            return;
        }
        TriRpcStatus status = TriRpcStatus.CANCELLED.withCause(t);
        status = message != null ? status.withDescription(message) : status.withDescription("Cancel by client without message");
        this.stream.cancelByLocal(status);
    }

    public boolean isAutoRequestN() {
        return this.autoRequestN;
    }

    public void setAutoRequestN(boolean autoRequestN) {
        this.autoRequestN = autoRequestN;
    }

    class ClientStreamListenerImpl
    implements ClientStreamListener {
        private final Listener listener;
        private final PackableMethod packableMethod;
        private boolean done;

        ClientStreamListenerImpl(Listener listener, PackableMethod packableMethod) {
            this.listener = listener;
            this.packableMethod = packableMethod;
        }

        @Override
        public void onStart() {
            this.listener.onStart(ClientCall.this);
        }

        @Override
        public void onMessage(byte[] message) {
            if (this.done) {
                LOGGER.warn("Received message from closed stream,connection=" + (Object)((Object)ClientCall.this.connection) + " service=" + ((ClientCall)ClientCall.this).requestMetadata.service + " method=" + ((ClientCall)ClientCall.this).requestMetadata.method.getMethodName());
                return;
            }
            try {
                Object unpacked = this.packableMethod.parseResponse(message);
                this.listener.onMessage(unpacked);
            }
            catch (IOException | ClassNotFoundException e) {
                this.cancelByErr(TriRpcStatus.INTERNAL.withDescription("Deserialize response failed").withCause(e));
            }
        }

        @Override
        public void complete(TriRpcStatus status, Map<String, Object> attachments, Map<String, String> excludeHeaders) {
            this.done = true;
            TriRpcStatus statusFromTrailers = this.getStatusFromTrailers(excludeHeaders);
            TriRpcStatus detailStatus = statusFromTrailers != null ? statusFromTrailers : status;
            try {
                this.listener.onClose(detailStatus, StreamUtils.toAttachments(attachments));
            }
            catch (Throwable t) {
                this.cancelByErr(TriRpcStatus.INTERNAL.withDescription("Close stream error").withCause(t));
            }
        }

        void cancelByErr(TriRpcStatus status) {
            ClientCall.this.stream.cancelByLocal(status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TriRpcStatus getStatusFromTrailers(Map<String, String> metadata) {
            if (null == metadata) {
                return null;
            }
            if (!metadata.containsKey(TripleHeaderEnum.STATUS_DETAIL_KEY.getHeader())) {
                return null;
            }
            String raw = metadata.remove(TripleHeaderEnum.STATUS_DETAIL_KEY.getHeader());
            byte[] statusDetailBin = StreamUtils.decodeASCIIByte(raw);
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Status statusDetail = Status.parseFrom(statusDetailBin);
                List<Any> detailList = statusDetail.getDetailsList();
                Map<Class<?>, Object> classObjectMap = this.tranFromStatusDetails(detailList);
                TriRpcStatus status = TriRpcStatus.fromCode(statusDetail.getCode()).withDescription(TriRpcStatus.decodeMessage(statusDetail.getMessage()));
                DebugInfo debugInfo = (DebugInfo)classObjectMap.get(DebugInfo.class);
                if (debugInfo != null) {
                    String msg = ExceptionUtils.getStackFrameString((List<String>)debugInfo.getStackEntriesList());
                    status = status.appendDescription(msg);
                }
                TriRpcStatus triRpcStatus = status;
                return triRpcStatus;
            }
            catch (IOException ioException) {
                TriRpcStatus triRpcStatus = null;
                return triRpcStatus;
            }
            finally {
                ClassLoadUtil.switchContextLoader(tccl);
            }
        }

        private Map<Class<?>, Object> tranFromStatusDetails(List<Any> detailList) {
            HashMap map = new HashMap();
            try {
                for (Any any : detailList) {
                    if (any.is(ErrorInfo.class)) {
                        ErrorInfo errorInfo = (ErrorInfo)any.unpack(ErrorInfo.class);
                        map.putIfAbsent(ErrorInfo.class, errorInfo);
                        continue;
                    }
                    if (!any.is(DebugInfo.class)) continue;
                    DebugInfo debugInfo = (DebugInfo)any.unpack(DebugInfo.class);
                    map.putIfAbsent(DebugInfo.class, debugInfo);
                }
            }
            catch (Throwable t) {
                LOGGER.error("tran from grpc-status-details error", t);
            }
            return map;
        }
    }

    public static interface Listener {
        public void onStart(ClientCall var1);

        public void onMessage(Object var1);

        public void onClose(TriRpcStatus var1, Map<String, Object> var2);
    }
}

