/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.MultipleSerialization;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.PackableMethod;
import org.apache.dubbo.rpc.protocol.tri.PbUnpack;
import org.apache.dubbo.triple.TripleWrapper;

public class ReflectionPackableMethod
implements PackableMethod {
    private static final String GRPC_ASYNC_RETURN_CLASS = "com.google.common.util.concurrent.ListenableFuture";
    private static final String TRI_ASYNC_RETURN_CLASS = "java.util.concurrent.CompletableFuture";
    private static final String REACTOR_RETURN_CLASS = "reactor.core.publisher.Mono";
    private static final String RX_RETURN_CLASS = "io.reactivex.Single";
    private static final String GRPC_STREAM_CLASS = "io.grpc.stub.StreamObserver";
    private static final PackableMethod.Pack PB_PACK = o -> ((Message)o).toByteArray();
    private final PackableMethod.Pack requestPack;
    private final PackableMethod.Pack responsePack;
    private final PackableMethod.UnPack requestUnpack;
    private final PackableMethod.UnPack responseUnpack;

    public ReflectionPackableMethod(MethodDescriptor method, URL url, String serializeName) {
        boolean singleArgument;
        Class actualResponseType;
        Class<?>[] actualRequestTypes;
        switch (method.getRpcType()) {
            case CLIENT_STREAM: 
            case BI_STREAM: {
                actualRequestTypes = new Class[]{(Class)((ParameterizedType)method.getMethod().getGenericReturnType()).getActualTypeArguments()[0]};
                actualResponseType = (Class)((ParameterizedType)method.getMethod().getGenericParameterTypes()[0]).getActualTypeArguments()[0];
                break;
            }
            case SERVER_STREAM: {
                actualRequestTypes = method.getMethod().getParameterTypes();
                actualResponseType = (Class)((ParameterizedType)method.getMethod().getGenericParameterTypes()[1]).getActualTypeArguments()[0];
                break;
            }
            case UNARY: {
                actualRequestTypes = method.getParameterClasses();
                actualResponseType = method.getReturnClass();
                break;
            }
            default: {
                throw new IllegalStateException("Can not reach here");
            }
        }
        boolean bl = singleArgument = method.getRpcType() != MethodDescriptor.RpcType.UNARY;
        if (!ReflectionPackableMethod.needWrap(method, actualRequestTypes, actualResponseType)) {
            this.requestPack = new PbArrayPacker(singleArgument);
            this.responsePack = PB_PACK;
            this.requestUnpack = new PbUnpack(actualRequestTypes[0]);
            this.responseUnpack = new PbUnpack(actualResponseType);
        } else {
            MultipleSerialization serialization = url.getOrDefaultFrameworkModel().getExtensionLoader(MultipleSerialization.class).getExtension(url.getParameter("serialize.multiple", "default"));
            String[] paramSigns = (String[])Stream.of(actualRequestTypes).map(Class::getName).toArray(String[]::new);
            this.requestPack = new WrapRequestPack(serialization, url, serializeName, paramSigns, singleArgument);
            this.responsePack = new WrapResponsePack(serialization, url, actualResponseType.getName());
            this.requestUnpack = new WrapRequestUnpack(serialization, url);
            this.responseUnpack = new WrapResponseUnpack(serialization, url);
        }
    }

    public static ReflectionPackableMethod init(MethodDescriptor methodDescriptor, URL url) {
        String serializeName = url.getParameter("serialization", "hessian2");
        Object stored = methodDescriptor.getAttribute("pack");
        if (stored != null) {
            return (ReflectionPackableMethod)stored;
        }
        ReflectionPackableMethod reflectionPackableMethod = new ReflectionPackableMethod(methodDescriptor, url, serializeName);
        methodDescriptor.addAttribute("pack", reflectionPackableMethod);
        return reflectionPackableMethod;
    }

    static boolean isStreamType(Class<?> type) {
        return StreamObserver.class.isAssignableFrom(type) || GRPC_STREAM_CLASS.equalsIgnoreCase(type.getName());
    }

    static boolean needWrap(MethodDescriptor methodDescriptor, Class<?>[] parameterClasses, Class<?> returnClass) {
        String methodName = methodDescriptor.getMethodName();
        if ("$invoke".equals(methodName) || "$invokeAsync".equals(methodName)) {
            return true;
        }
        if ("$echo".equals(methodName)) {
            return true;
        }
        boolean returnClassProtobuf = ReflectionPackableMethod.isProtobufClass(returnClass);
        if (parameterClasses.length == 0) {
            return !returnClassProtobuf;
        }
        int protobufParameterCount = 0;
        int javaParameterCount = 0;
        int streamParameterCount = 0;
        boolean secondParameterStream = false;
        for (int i = 0; i < parameterClasses.length; ++i) {
            Class<?> parameterClass = parameterClasses[i];
            if (ReflectionPackableMethod.isProtobufClass(parameterClass)) {
                ++protobufParameterCount;
                continue;
            }
            if (ReflectionPackableMethod.isStreamType(parameterClass)) {
                if (i == 1) {
                    secondParameterStream = true;
                }
                ++streamParameterCount;
                continue;
            }
            ++javaParameterCount;
        }
        if (streamParameterCount > 1) {
            throw new IllegalStateException("method params error: more than one Stream params. method=" + methodName);
        }
        if (protobufParameterCount >= 2) {
            throw new IllegalStateException("method params error: more than one protobuf params. method=" + methodName);
        }
        if (streamParameterCount == 1) {
            if (javaParameterCount + protobufParameterCount > 1) {
                throw new IllegalStateException("method params error: server stream does not support more than one normal param. method=" + methodName);
            }
            if (!secondParameterStream) {
                throw new IllegalStateException("method params error: server stream's second param must be StreamObserver. method=" + methodName);
            }
        }
        if (methodDescriptor.getRpcType() != MethodDescriptor.RpcType.UNARY) {
            if (MethodDescriptor.RpcType.SERVER_STREAM == methodDescriptor.getRpcType() && !secondParameterStream) {
                throw new IllegalStateException("method params error:server stream's second param must be StreamObserver. method=" + methodName);
            }
            if (returnClassProtobuf) {
                if (javaParameterCount > 0) {
                    throw new IllegalStateException("method params error: both normal and protobuf param found. method=" + methodName);
                }
            } else if (protobufParameterCount > 0) {
                throw new IllegalStateException("method params error method=" + methodName);
            }
        } else {
            boolean ignore;
            if (streamParameterCount > 0) {
                throw new IllegalStateException("method params error: unary method should not contain any StreamObserver. method=" + methodName);
            }
            if (protobufParameterCount > 0 && returnClassProtobuf) {
                return false;
            }
            if (ReflectionPackableMethod.isMono(returnClass) || ReflectionPackableMethod.isRx(returnClass)) {
                return false;
            }
            if (protobufParameterCount <= 0 && !returnClassProtobuf) {
                return true;
            }
            if (GRPC_ASYNC_RETURN_CLASS.equalsIgnoreCase(returnClass.getName()) && protobufParameterCount == 1) {
                return false;
            }
            if (TRI_ASYNC_RETURN_CLASS.equalsIgnoreCase(returnClass.getName())) {
                Class actualReturnClass = (Class)((ParameterizedType)methodDescriptor.getMethod().getGenericReturnType()).getActualTypeArguments()[0];
                boolean actualReturnClassProtobuf = ReflectionPackableMethod.isProtobufClass(actualReturnClass);
                if (actualReturnClassProtobuf && protobufParameterCount == 1) {
                    return false;
                }
                if (!actualReturnClassProtobuf && protobufParameterCount == 0) {
                    return true;
                }
            }
            if (ignore = ReflectionPackableMethod.checkNeedIgnore(returnClass)) {
                return protobufParameterCount != 1;
            }
            throw new IllegalStateException("method params error method=" + methodName);
        }
        return javaParameterCount > 0;
    }

    static boolean checkNeedIgnore(Class<?> returnClass) {
        return Iterator.class.isAssignableFrom(returnClass);
    }

    static boolean isMono(Class<?> clz) {
        return REACTOR_RETURN_CLASS.equalsIgnoreCase(clz.getName());
    }

    static boolean isRx(Class<?> clz) {
        return RX_RETURN_CLASS.equalsIgnoreCase(clz.getName());
    }

    static boolean isProtobufClass(Class<?> clazz) {
        while (clazz != Object.class && clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length > 0) {
                for (Class<?> clazzInterface : interfaces) {
                    if (!"com.google.protobuf.Message".equalsIgnoreCase(clazzInterface.getName())) continue;
                    return true;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    private static String convertHessianFromWrapper(String serializeType) {
        if ("hessian4".equals(serializeType)) {
            return "hessian2";
        }
        return serializeType;
    }

    @Override
    public PackableMethod.Pack getRequestPack() {
        return this.requestPack;
    }

    @Override
    public PackableMethod.Pack getResponsePack() {
        return this.responsePack;
    }

    @Override
    public PackableMethod.UnPack getResponseUnpack() {
        return this.responseUnpack;
    }

    @Override
    public PackableMethod.UnPack getRequestUnpack() {
        return this.requestUnpack;
    }

    private class WrapRequestUnpack
    implements PackableMethod.UnPack {
        private final MultipleSerialization serialization;
        private final URL url;

        private WrapRequestUnpack(MultipleSerialization serialization, URL url) {
            this.serialization = serialization;
            this.url = url;
        }

        @Override
        public Object unpack(byte[] data) throws IOException, ClassNotFoundException {
            String serializeType;
            TripleWrapper.TripleRequestWrapper wrapper = TripleWrapper.TripleRequestWrapper.parseFrom(data);
            Object[] ret = new Object[wrapper.getArgsCount()];
            ((WrapResponsePack)((ReflectionPackableMethod)ReflectionPackableMethod.this).responsePack).serialize = serializeType = ReflectionPackableMethod.convertHessianFromWrapper(wrapper.getSerializeType());
            for (int i = 0; i < wrapper.getArgsList().size(); ++i) {
                ByteArrayInputStream bais = new ByteArrayInputStream(wrapper.getArgs(i).toByteArray());
                ret[i] = this.serialization.deserialize(this.url, serializeType, wrapper.getArgTypes(i), bais);
            }
            return ret;
        }
    }

    private static class PbArrayPacker
    implements PackableMethod.Pack {
        private final boolean singleArgument;

        private PbArrayPacker(boolean singleArgument) {
            this.singleArgument = singleArgument;
        }

        @Override
        public byte[] pack(Object obj) throws IOException {
            if (!this.singleArgument) {
                obj = ((Object[])obj)[0];
            }
            return PB_PACK.pack(obj);
        }
    }

    private static class WrapRequestPack
    implements PackableMethod.Pack {
        private final String serialize;
        private final MultipleSerialization multipleSerialization;
        private final String[] argumentsType;
        private final URL url;
        private final boolean singleArgument;

        private WrapRequestPack(MultipleSerialization multipleSerialization, URL url, String serialize, String[] argumentsType, boolean singleArgument) {
            this.url = url;
            this.serialize = this.convertHessianToWrapper(serialize);
            this.multipleSerialization = multipleSerialization;
            this.argumentsType = argumentsType;
            this.singleArgument = singleArgument;
        }

        @Override
        public byte[] pack(Object obj) throws IOException {
            Object[] arguments = this.singleArgument ? new Object[]{obj} : (Object[])obj;
            TripleWrapper.TripleRequestWrapper.Builder builder = TripleWrapper.TripleRequestWrapper.newBuilder().setSerializeType(this.serialize);
            for (String type : this.argumentsType) {
                builder.addArgTypes(type);
            }
            for (Object argument : arguments) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                this.multipleSerialization.serialize(this.url, this.serialize, null, argument, bos);
                builder.addArgs(ByteString.copyFrom((byte[])bos.toByteArray()));
            }
            return builder.build().toByteArray();
        }

        private String convertHessianToWrapper(String serializeType) {
            if ("hessian2".equals(serializeType)) {
                return "hessian4";
            }
            return serializeType;
        }
    }

    private static class WrapResponseUnpack
    implements PackableMethod.UnPack {
        private final MultipleSerialization serialization;
        private final URL url;

        private WrapResponseUnpack(MultipleSerialization serialization, URL url) {
            this.serialization = serialization;
            this.url = url;
        }

        @Override
        public Object unpack(byte[] data) throws IOException, ClassNotFoundException {
            TripleWrapper.TripleResponseWrapper wrapper = TripleWrapper.TripleResponseWrapper.parseFrom(data);
            String serializeType = ReflectionPackableMethod.convertHessianFromWrapper(wrapper.getSerializeType());
            ByteArrayInputStream bais = new ByteArrayInputStream(wrapper.getData().toByteArray());
            return this.serialization.deserialize(this.url, serializeType, wrapper.getType(), bais);
        }
    }

    private static class WrapResponsePack
    implements PackableMethod.Pack {
        private final MultipleSerialization multipleSerialization;
        private final URL url;
        private final String returnType;
        String serialize;

        private WrapResponsePack(MultipleSerialization multipleSerialization, URL url, String returnType) {
            this.multipleSerialization = multipleSerialization;
            this.url = url;
            this.returnType = returnType;
        }

        @Override
        public byte[] pack(Object obj) throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.multipleSerialization.serialize(this.url, this.serialize, null, obj, bos);
            return TripleWrapper.TripleResponseWrapper.newBuilder().setSerializeType(this.serialize).setType(this.returnType).setData(ByteString.copyFrom((byte[])bos.toByteArray())).build().toByteArray();
        }
    }
}

