/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.Cleanable;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.Codec;
import org.apache.dubbo.remoting.Decodeable;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.dubbo.CallbackServiceCodec;
import org.apache.dubbo.rpc.protocol.dubbo.DubboCodec;
import org.apache.dubbo.rpc.support.RpcUtils;

public class DecodeableRpcInvocation
extends RpcInvocation
implements Codec,
Decodeable {
    private static final Logger log = LoggerFactory.getLogger(DecodeableRpcInvocation.class);
    private Channel channel;
    private byte serializationType;
    private InputStream inputStream;
    private Request request;
    private volatile boolean hasDecoded;
    protected final FrameworkModel frameworkModel;
    private CallbackServiceCodec callbackServiceCodec;

    public DecodeableRpcInvocation(FrameworkModel frameworkModel, Channel channel, Request request, InputStream is, byte id) {
        this.frameworkModel = frameworkModel;
        Assert.notNull((Object)channel, "channel == null");
        Assert.notNull((Object)request, "request == null");
        Assert.notNull((Object)is, "inputStream == null");
        this.channel = channel;
        this.request = request;
        this.inputStream = is;
        this.serializationType = id;
        this.callbackServiceCodec = new CallbackServiceCodec(frameworkModel);
    }

    @Override
    public void decode() throws Exception {
        if (!this.hasDecoded && this.channel != null && this.inputStream != null) {
            try {
                this.decode(this.channel, this.inputStream);
            }
            catch (Throwable e) {
                if (log.isWarnEnabled()) {
                    log.warn("Decode rpc invocation failed: " + e.getMessage(), e);
                }
                this.request.setBroken(true);
                this.request.setData(e);
            }
            finally {
                this.hasDecoded = true;
            }
        }
    }

    @Override
    public void encode(Channel channel, OutputStream output, Object message) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void checkSerializationTypeFromRemote() {
    }

    @Override
    public Object decode(Channel channel, InputStream input) throws IOException {
        ObjectInput in = CodecSupport.getSerialization(channel.getUrl(), this.serializationType).deserialize(channel.getUrl(), input);
        this.put("serialization_id", this.serializationType);
        String dubboVersion = in.readUTF();
        this.request.setVersion(dubboVersion);
        this.setAttachment("dubbo", dubboVersion);
        String path = in.readUTF();
        this.setAttachment("path", path);
        String version = in.readUTF();
        this.setAttachment("version", version);
        this.setMethodName(in.readUTF());
        String desc = in.readUTF();
        this.setParameterTypesDesc(desc);
        ClassLoader originClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (Boolean.parseBoolean(System.getProperty("serialization.security.check", "true"))) {
                CodecSupport.checkSerialization(this.frameworkModel.getServiceRepository(), path, version, this.serializationType);
            }
            Object[] args = DubboCodec.EMPTY_OBJECT_ARRAY;
            Class<?>[] pts = DubboCodec.EMPTY_CLASS_ARRAY;
            if (desc.length() > 0) {
                MethodDescriptor methodDescriptor;
                FrameworkServiceRepository repository = this.frameworkModel.getServiceRepository();
                List<ProviderModel> providerModels = repository.lookupExportedServicesWithoutGroup(BaseServiceMetadata.keyWithoutGroup(path, version));
                ServiceDescriptor serviceDescriptor = null;
                if (CollectionUtils.isNotEmpty(providerModels)) {
                    ProviderModel providerModel;
                    Iterator<Object> iterator = providerModels.iterator();
                    while (iterator.hasNext() && (serviceDescriptor = (providerModel = iterator.next()).getServiceModel()) == null) {
                    }
                }
                if (serviceDescriptor == null) {
                    for (ApplicationModel applicationModel : this.frameworkModel.getApplicationModels()) {
                        ModuleModel moduleModel;
                        Iterator<ModuleModel> iterator = applicationModel.getModuleModels().iterator();
                        while (iterator.hasNext() && (serviceDescriptor = (moduleModel = iterator.next()).getServiceRepository().lookupService(path)) == null) {
                        }
                    }
                }
                if (serviceDescriptor != null && (methodDescriptor = serviceDescriptor.getMethod(this.getMethodName(), desc)) != null) {
                    pts = methodDescriptor.getParameterClasses();
                    this.setReturnTypes(methodDescriptor.getReturnTypes());
                    if (CollectionUtils.isNotEmpty(providerModels)) {
                        if (providerModels.size() == 1) {
                            Thread.currentThread().setContextClassLoader(providerModels.get(0).getClassLoader());
                        } else {
                            for (ProviderModel providerModel : providerModels) {
                                ClassLoader classLoader = providerModel.getClassLoader();
                                boolean match = true;
                                for (Class<?> pt : pts) {
                                    try {
                                        if (pt.equals(classLoader.loadClass(pt.getName()))) continue;
                                        match = false;
                                    }
                                    catch (ClassNotFoundException e) {
                                        match = false;
                                    }
                                }
                                if (!match) continue;
                                Thread.currentThread().setContextClassLoader(classLoader);
                                break;
                            }
                        }
                    }
                }
                if (pts == DubboCodec.EMPTY_CLASS_ARRAY) {
                    if (!RpcUtils.isGenericCall(desc, this.getMethodName()) && !RpcUtils.isEcho(desc, this.getMethodName())) {
                        throw new IllegalArgumentException("Service not found:" + path + ", " + this.getMethodName());
                    }
                    pts = ReflectUtils.desc2classArray(desc);
                }
                args = new Object[pts.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = in.readObject(pts[i]);
                }
            }
            this.setParameterTypes(pts);
            Map<String, Object> map = in.readAttachments();
            if (CollectionUtils.isNotEmptyMap(map)) {
                Map<String, Object> attachment = this.getObjectAttachments();
                if (attachment == null) {
                    attachment = new HashMap<String, Object>();
                }
                attachment.putAll(map);
                this.setObjectAttachments(attachment);
            }
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.callbackServiceCodec.decodeInvocationArgument(channel, this, pts, i, args[i]);
            }
            this.setArguments(args);
            String targetServiceName = URL.buildKey(this.getAttachment("path"), this.getAttachment("group"), this.getAttachment("version"));
            this.setTargetServiceUniqueName(targetServiceName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(StringUtils.toString("Read invocation data failed.", e));
        }
        finally {
            Thread.currentThread().setContextClassLoader(originClassLoader);
            if (in instanceof Cleanable) {
                ((Cleanable)((Object)in)).cleanup();
            }
        }
        return this;
    }
}

