/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.tag;

import java.util.List;
import java.util.function.Predicate;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Holder;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotNode;
import org.apache.dubbo.rpc.cluster.router.state.AbstractStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.tag.model.TagRouterRule;
import org.apache.dubbo.rpc.cluster.router.tag.model.TagRuleParser;

public class TagStateRouter<T>
extends AbstractStateRouter<T>
implements ConfigurationListener {
    public static final String NAME = "TAG_ROUTER";
    private static final Logger logger = LoggerFactory.getLogger(TagStateRouter.class);
    private static final String RULE_SUFFIX = ".tag-router";
    private TagRouterRule tagRouterRule;
    private String application;

    public TagStateRouter(URL url) {
        super(url);
    }

    @Override
    public synchronized void process(ConfigChangedEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("Notification of tag rule, change type is: " + (Object)((Object)event.getChangeType()) + ", raw rule is:\n " + event.getContent());
        }
        try {
            this.tagRouterRule = event.getChangeType().equals((Object)ConfigChangeType.DELETED) ? null : TagRuleParser.parse(event.getContent());
        }
        catch (Exception e) {
            logger.error("Failed to parse the raw tag router rule and it will not take effect, please check if the rule matches with the template, the raw rule is:\n ", e);
        }
    }

    @Override
    public BitList<Invoker<T>> doRoute(BitList<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage, Holder<RouterSnapshotNode<T>> nodeHolder, Holder<String> messageHolder) throws RpcException {
        String tag;
        if (CollectionUtils.isEmpty(invokers)) {
            if (needToPrintMessage) {
                messageHolder.set("Directly Return. Reason: Invokers from previous router is empty.");
            }
            return invokers;
        }
        TagRouterRule tagRouterRuleCopy = this.tagRouterRule;
        if (tagRouterRuleCopy == null || !tagRouterRuleCopy.isValid() || !tagRouterRuleCopy.isEnabled()) {
            if (needToPrintMessage) {
                messageHolder.set("Disable Tag Router. Reason: tagRouterRule is invalid or disabled");
            }
            return this.filterUsingStaticTag(invokers, url, invocation);
        }
        BitList<Invoker<T>> result = invokers;
        String string = tag = StringUtils.isEmpty(invocation.getAttachment("dubbo.tag")) ? url.getParameter("dubbo.tag") : invocation.getAttachment("dubbo.tag");
        if (StringUtils.isNotEmpty(tag)) {
            List<String> addresses = tagRouterRuleCopy.getTagnameToAddresses().get(tag);
            if (CollectionUtils.isNotEmpty(addresses)) {
                result = this.filterInvoker(invokers, invoker -> this.addressMatches(invoker.getUrl(), addresses));
                if (CollectionUtils.isNotEmpty(result) || tagRouterRuleCopy.isForce()) {
                    if (needToPrintMessage) {
                        messageHolder.set("Use tag " + tag + " to route. Reason: result is not null OR it's null but force=true");
                    }
                    return result;
                }
            } else {
                result = this.filterInvoker(invokers, invoker -> tag.equals(invoker.getUrl().getParameter("dubbo.tag")));
            }
            if (CollectionUtils.isNotEmpty(result) || this.isForceUseTag(invocation)) {
                if (needToPrintMessage) {
                    messageHolder.set("Use tag " + tag + " to route. Reason: result is not empty or ForceUseTag key is true in invocation");
                }
                return result;
            }
            BitList<Invoker<T>> tmp = this.filterInvoker(invokers, invoker -> this.addressNotMatches(invoker.getUrl(), tagRouterRuleCopy.getAddresses()));
            if (needToPrintMessage) {
                messageHolder.set("FAILOVER: return all Providers without any tags");
            }
            return this.filterInvoker(tmp, invoker -> StringUtils.isEmpty(invoker.getUrl().getParameter("dubbo.tag")));
        }
        List<String> addresses = tagRouterRuleCopy.getAddresses();
        if (CollectionUtils.isNotEmpty(addresses) && CollectionUtils.isEmpty(result = this.filterInvoker(invokers, invoker -> this.addressNotMatches(invoker.getUrl(), addresses)))) {
            if (needToPrintMessage) {
                messageHolder.set("all addresses are in dynamic tag group, return empty list");
            }
            return result;
        }
        if (needToPrintMessage) {
            messageHolder.set("filter using the static tag group");
        }
        return this.filterInvoker(result, invoker -> {
            String localTag = invoker.getUrl().getParameter("dubbo.tag");
            return StringUtils.isEmpty(localTag) || !tagRouterRuleCopy.getTagNames().contains(localTag);
        });
    }

    private <T> BitList<Invoker<T>> filterUsingStaticTag(BitList<Invoker<T>> invokers, URL url, Invocation invocation) {
        BitList<Invoker<T>> result;
        String tag;
        String string = tag = StringUtils.isEmpty(invocation.getAttachment("dubbo.tag")) ? url.getParameter("dubbo.tag") : invocation.getAttachment("dubbo.tag");
        if (!StringUtils.isEmpty(tag)) {
            result = this.filterInvoker(invokers, invoker -> tag.equals(invoker.getUrl().getParameter("dubbo.tag")));
            if (CollectionUtils.isEmpty(result) && !this.isForceUseTag(invocation)) {
                result = this.filterInvoker(invokers, invoker -> StringUtils.isEmpty(invoker.getUrl().getParameter("dubbo.tag")));
            }
        } else {
            result = this.filterInvoker(invokers, invoker -> StringUtils.isEmpty(invoker.getUrl().getParameter("dubbo.tag")));
        }
        return result;
    }

    @Override
    public boolean isRuntime() {
        return this.tagRouterRule != null && this.tagRouterRule.isRuntime();
    }

    @Override
    public boolean isForce() {
        return this.tagRouterRule != null && this.tagRouterRule.isForce();
    }

    private boolean isForceUseTag(Invocation invocation) {
        return Boolean.parseBoolean(invocation.getAttachment("dubbo.force.tag", this.getUrl().getParameter("dubbo.force.tag", "false")));
    }

    private <T> BitList<Invoker<T>> filterInvoker(BitList<Invoker<T>> invokers, Predicate<Invoker<T>> predicate) {
        if (invokers.stream().allMatch(predicate)) {
            return invokers;
        }
        Object newInvokers = invokers.clone();
        newInvokers.removeIf(invoker -> !predicate.test((Invoker)invoker));
        return newInvokers;
    }

    private boolean addressMatches(URL url, List<String> addresses) {
        return addresses != null && this.checkAddressMatch(addresses, url.getHost(), url.getPort());
    }

    private boolean addressNotMatches(URL url, List<String> addresses) {
        return addresses == null || !this.checkAddressMatch(addresses, url.getHost(), url.getPort());
    }

    private boolean checkAddressMatch(List<String> addresses, String host, int port) {
        for (String address : addresses) {
            try {
                if (NetUtils.matchIpExpression(address, host, port)) {
                    return true;
                }
                if (!("0.0.0.0:" + port).equals(address)) continue;
                return true;
            }
            catch (Exception e) {
                logger.error("The format of ip address is invalid in tag route. Address :" + address, e);
            }
        }
        return false;
    }

    public void setApplication(String app) {
        this.application = app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(BitList<Invoker<T>> invokers) {
        if (CollectionUtils.isEmpty(invokers)) {
            return;
        }
        Invoker<T> invoker = invokers.get(0);
        URL url = invoker.getUrl();
        String providerApplication = url.getRemoteApplication();
        if (StringUtils.isEmpty(providerApplication)) {
            logger.error("TagRouter must getConfig from or subscribe to a specific application, but the application in this TagRouter is not specified.");
            return;
        }
        TagStateRouter tagStateRouter = this;
        synchronized (tagStateRouter) {
            if (!providerApplication.equals(this.application)) {
                if (StringUtils.isNotEmpty(this.application)) {
                    this.getRuleRepository().removeListener(this.application + RULE_SUFFIX, this);
                }
                String key = providerApplication + RULE_SUFFIX;
                this.getRuleRepository().addListener(key, this);
                this.application = providerApplication;
                String rawRule = this.getRuleRepository().getRule(key, "dubbo");
                if (StringUtils.isNotEmpty(rawRule)) {
                    this.process(new ConfigChangedEvent(key, "dubbo", rawRule));
                }
            }
        }
    }

    @Override
    public void stop() {
        if (StringUtils.isNotEmpty(this.application)) {
            this.getRuleRepository().removeListener(this.application + RULE_SUFFIX, this);
        }
    }
}

