/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.merger;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.TypeUtils;
import org.apache.dubbo.rpc.cluster.Merger;
import org.apache.dubbo.rpc.cluster.merger.ArrayMerger;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

public class MergerFactory
implements ScopeModelAware {
    private static final Logger logger = LoggerFactory.getLogger(MergerFactory.class);
    private ConcurrentMap<Class<?>, Merger<?>> MERGER_CACHE = new ConcurrentHashMap();
    private ScopeModel scopeModel;

    @Override
    public void setScopeModel(ScopeModel scopeModel) {
        this.scopeModel = scopeModel;
    }

    public <T> Merger<T> getMerger(Class<T> returnType) {
        Merger merger;
        if (returnType == null) {
            throw new IllegalArgumentException("returnType is null");
        }
        if (CollectionUtils.isEmptyMap(this.MERGER_CACHE)) {
            this.loadMergers();
        }
        if ((merger = (Merger)this.MERGER_CACHE.get(returnType)) == null && returnType.isArray()) {
            merger = ArrayMerger.INSTANCE;
        }
        return merger;
    }

    private void loadMergers() {
        Set<String> names = this.scopeModel.getExtensionLoader(Merger.class).getSupportedExtensions();
        for (String name : names) {
            Merger m = this.scopeModel.getExtensionLoader(Merger.class).getExtension(name);
            Class<?> actualTypeArg = this.getActualTypeArgument(m.getClass());
            if (actualTypeArg == null) {
                logger.warn("Failed to get actual type argument from merger " + m.getClass().getName());
                continue;
            }
            this.MERGER_CACHE.putIfAbsent(actualTypeArg, m);
        }
    }

    private Class<?> getActualTypeArgument(Class<? extends Merger> mergerCls) {
        for (Class<? extends Merger> superClass = mergerCls; superClass != Object.class; superClass = superClass.getSuperclass()) {
            Type[] interfaceTypes;
            for (Type it : interfaceTypes = superClass.getGenericInterfaces()) {
                ParameterizedType mergerType;
                if (!(it instanceof ParameterizedType) || (mergerType = (ParameterizedType)it).getRawType() != Merger.class) continue;
                Type typeArg = mergerType.getActualTypeArguments()[0];
                return TypeUtils.getRawClass(typeArg);
            }
        }
        return null;
    }
}

