/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.MetadataServiceURLBuilder;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.service.Destroyable;

public class MetadataUtils {
    public static final Logger logger = LoggerFactory.getLogger(MetadataUtils.class);

    public static void publishServiceDefinition(URL url, ServiceDescriptor serviceDescriptor, ApplicationModel applicationModel) {
        if (MetadataUtils.getMetadataReports(applicationModel).size() == 0) {
            String msg = "Remote Metadata Report Server not hasn't been configured or unavailable . Unable to get Metadata from remote!";
            logger.warn(msg);
        }
        try {
            String side = url.getSide();
            if ("provider".equalsIgnoreCase(side)) {
                String serviceKey = url.getServiceKey();
                FullServiceDefinition serviceDefinition = serviceDescriptor.getFullServiceDefinition(serviceKey);
                if (StringUtils.isNotEmpty(serviceKey) && serviceDefinition != null) {
                    serviceDefinition.setParameters(url.getParameters());
                    for (Map.Entry<String, MetadataReport> entry : MetadataUtils.getMetadataReports(applicationModel).entrySet()) {
                        MetadataReport metadataReport = entry.getValue();
                        if (!metadataReport.shouldReportDefinition()) {
                            logger.info("Report of service definition is disabled for " + entry.getKey());
                            continue;
                        }
                        metadataReport.storeProviderMetadata(new MetadataIdentifier(url.getServiceInterface(), url.getVersion() == null ? "" : url.getVersion(), url.getGroup() == null ? "" : url.getGroup(), "provider", applicationModel.getApplicationName()), serviceDefinition);
                    }
                }
            } else {
                for (Map.Entry<String, MetadataReport> entry : MetadataUtils.getMetadataReports(applicationModel).entrySet()) {
                    MetadataReport metadataReport = entry.getValue();
                    if (!metadataReport.shouldReportDefinition()) {
                        logger.info("Report of service definition is disabled for " + entry.getKey());
                        continue;
                    }
                    metadataReport.storeConsumerMetadata(new MetadataIdentifier(url.getServiceInterface(), url.getVersion() == null ? "" : url.getVersion(), url.getGroup() == null ? "" : url.getGroup(), "consumer", applicationModel.getApplicationName()), url.getParameters());
                }
            }
        }
        catch (Exception e) {
            logger.error("publish service definition metadata error.", e);
        }
    }

    public static MetadataService referProxy(ServiceInstance instance) {
        ExtensionLoader<MetadataServiceURLBuilder> loader = instance.getApplicationModel().getExtensionLoader(MetadataServiceURLBuilder.class);
        Map<String, String> metadata = instance.getMetadata();
        String dubboUrlsForJson = metadata.get("dubbo.metadata-service.urls");
        MetadataServiceURLBuilder builder = metadata.isEmpty() || StringUtils.isEmpty(dubboUrlsForJson) ? loader.getExtension("standard") : loader.getExtension("spring-cloud");
        List<URL> urls = builder.build(instance);
        if (CollectionUtils.isEmpty(urls)) {
            throw new IllegalStateException("Introspection service discovery mode is enabled " + instance + ", but no metadata service can build from it.");
        }
        ApplicationModel scopeModel = instance.getApplicationModel();
        Protocol protocol = scopeModel.getExtensionLoader(Protocol.class).getAdaptiveExtension();
        Invoker<MetadataService> invoker = protocol.refer(MetadataService.class, urls.get(0));
        ProxyFactory proxyFactory = scopeModel.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
        return proxyFactory.getProxy(invoker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataInfo getRemoteMetadata(String revision, List<ServiceInstance> instances, MetadataReport metadataReport) {
        MetadataInfo metadataInfo;
        block9: {
            ServiceInstance instance = MetadataUtils.selectInstance(instances);
            String metadataType = ServiceInstanceMetadataUtils.getMetadataStorageType(instance);
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Instance " + instance.getAddress() + " is using metadata type " + metadataType);
                }
                if ("remote".equals(metadataType)) {
                    metadataInfo = MetadataUtils.getMetadata(revision, instance, metadataReport);
                    break block9;
                }
                MetadataService metadataServiceProxy = null;
                try {
                    metadataServiceProxy = MetadataUtils.referProxy(instance);
                    metadataInfo = metadataServiceProxy.getMetadataInfo(ServiceInstanceMetadataUtils.getExportedServicesRevision(instance));
                }
                finally {
                    if (metadataServiceProxy instanceof Destroyable) {
                        ((Destroyable)((Object)metadataServiceProxy)).$destroy();
                    }
                }
            }
            catch (Exception e) {
                logger.error("Failed to get app metadata for revision " + revision + " for type " + metadataType + " from instance " + instance.getAddress(), e);
                metadataInfo = null;
            }
        }
        if (metadataInfo == null) {
            metadataInfo = MetadataInfo.EMPTY;
        }
        return metadataInfo;
    }

    public static MetadataInfo getMetadata(String revision, ServiceInstance instance, MetadataReport metadataReport) {
        SubscriberMetadataIdentifier identifier = new SubscriberMetadataIdentifier(instance.getServiceName(), revision);
        if (metadataReport == null) {
            throw new IllegalStateException("No valid remote metadata report specified.");
        }
        String registryCluster = instance.getRegistryCluster();
        HashMap<String, String> params = new HashMap<String, String>(instance.getExtendParams());
        if (registryCluster != null && !registryCluster.equalsIgnoreCase((String)params.get("REGISTRY_CLUSTER"))) {
            params.put("REGISTRY_CLUSTER", registryCluster);
        }
        return metadataReport.getAppMetadata(identifier, params);
    }

    private static Map<String, MetadataReport> getMetadataReports(ApplicationModel applicationModel) {
        return applicationModel.getBeanFactory().getBean(MetadataReportInstance.class).getMetadataReports(false);
    }

    private static ServiceInstance selectInstance(List<ServiceInstance> instances) {
        if (instances.size() == 1) {
            return instances.get(0);
        }
        return instances.get(ThreadLocalRandom.current().nextInt(0, instances.size()));
    }
}

