/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.config.bootstrap.BootstrapTakeoverMode;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.apache.dubbo.config.spring.context.DubboBootstrapStartStopListenerSpringAdapter;
import org.apache.dubbo.config.spring.context.DubboConfigBeanInitializer;
import org.apache.dubbo.config.spring.context.event.DubboConfigInitEvent;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.util.ObjectUtils;

@Deprecated
public class DubboBootstrapApplicationListener
implements ApplicationListener,
ApplicationContextAware,
Ordered {
    public static final String BEAN_NAME = "dubboBootstrapApplicationListener";
    private final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;
    private DubboBootstrap bootstrap;
    private boolean shouldInitConfigBeans;
    private ModuleModel moduleModel;

    public DubboBootstrapApplicationListener() {
    }

    public DubboBootstrapApplicationListener(boolean shouldInitConfigBeans) {
        this.shouldInitConfigBeans = shouldInitConfigBeans;
    }

    private void setBootstrap(DubboBootstrap bootstrap) {
        this.bootstrap = bootstrap;
        if (bootstrap.getTakeoverMode() != BootstrapTakeoverMode.MANUAL) {
            bootstrap.setTakeoverMode(BootstrapTakeoverMode.SPRING);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.isOriginalEventSource(event)) {
            if (event instanceof DubboConfigInitEvent) {
                this.initDubboConfigBeans();
            } else if (event instanceof ApplicationContextEvent) {
                this.onApplicationContextEvent((ApplicationContextEvent)event);
            }
        }
    }

    private void initDubboConfigBeans() {
        if (this.applicationContext.containsBean(DubboConfigBeanInitializer.BEAN_NAME)) {
            this.applicationContext.getBean(DubboConfigBeanInitializer.BEAN_NAME, DubboConfigBeanInitializer.class);
        } else {
            this.logger.warn((Object)("Bean '" + DubboConfigBeanInitializer.BEAN_NAME + "' was not found"));
        }
        this.moduleModel.getDeployer().initialize();
    }

    private void onApplicationContextEvent(ApplicationContextEvent event) {
        if (DubboBootstrapStartStopListenerSpringAdapter.applicationContext == null) {
            DubboBootstrapStartStopListenerSpringAdapter.applicationContext = event.getApplicationContext();
        }
        if (event instanceof ContextRefreshedEvent) {
            this.onContextRefreshedEvent((ContextRefreshedEvent)event);
        } else if (event instanceof ContextClosedEvent) {
            this.onContextClosedEvent((ContextClosedEvent)event);
        }
    }

    private void onContextRefreshedEvent(ContextRefreshedEvent event) {
        if (this.bootstrap.getTakeoverMode() == BootstrapTakeoverMode.SPRING) {
            this.moduleModel.getDeployer().start();
        }
    }

    private void onContextClosedEvent(ContextClosedEvent event) {
        if (this.bootstrap.getTakeoverMode() == BootstrapTakeoverMode.SPRING) {
            this.moduleModel.getDeployer().stop();
        }
    }

    private boolean isOriginalEventSource(ApplicationEvent event) {
        boolean originalEventSource = ObjectUtils.nullSafeEquals((Object)this.getApplicationContext(), (Object)event.getSource());
        return originalEventSource;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.moduleModel = DubboBeanUtils.getModuleModel((BeanFactory)applicationContext);
        this.setBootstrap(DubboBootstrap.getInstance(this.moduleModel.getApplicationModel()));
        if (this.shouldInitConfigBeans) {
            this.checkCallStackAndInit();
        }
    }

    private void checkCallStackAndInit() {
        Exception exception = new Exception();
        StackTraceElement[] stackTrace = exception.getStackTrace();
        boolean found = false;
        for (StackTraceElement frame : stackTrace) {
            if (!frame.getMethodName().equals("registerListeners") || !frame.getClassName().endsWith("AbstractApplicationContext")) continue;
            found = true;
            break;
        }
        if (found) {
            this.initDubboConfigBeans();
        } else {
            this.logger.warn((Object)"DubboBootstrapApplicationListener initialization is unexpected, it should be created in AbstractApplicationContext.registerListeners() method", (Throwable)exception);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

