/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import org.apache.dubbo.common.deploy.ApplicationDeployListener;
import org.apache.dubbo.common.lang.Prioritized;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.metadata.ConfigurableMetadataServiceExporter;
import org.apache.dubbo.config.metadata.MetadataServiceDelegation;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ExporterDeployListener
implements ApplicationDeployListener,
Prioritized {
    protected volatile ConfigurableMetadataServiceExporter metadataServiceExporter;

    @Override
    public void onStarting(ApplicationModel scopeModel) {
    }

    @Override
    public synchronized void onStarted(ApplicationModel applicationModel) {
    }

    @Override
    public synchronized void onStopping(ApplicationModel scopeModel) {
    }

    private String getMetadataType(ApplicationModel applicationModel) {
        String type = applicationModel.getApplicationConfigManager().getApplicationOrElseThrow().getMetadataType();
        if (StringUtils.isEmpty(type)) {
            type = "local";
        }
        return type;
    }

    public ConfigurableMetadataServiceExporter getMetadataServiceExporter() {
        return this.metadataServiceExporter;
    }

    public void setMetadataServiceExporter(ConfigurableMetadataServiceExporter metadataServiceExporter) {
        this.metadataServiceExporter = metadataServiceExporter;
    }

    @Override
    public synchronized void onModuleStarted(ApplicationModel applicationModel) {
        MetadataServiceDelegation metadataService = applicationModel.getBeanFactory().getOrRegisterBean(MetadataServiceDelegation.class);
        if (this.metadataServiceExporter == null) {
            this.metadataServiceExporter = new ConfigurableMetadataServiceExporter(applicationModel, metadataService);
            if (!"remote".equals(this.getMetadataType(applicationModel))) {
                this.metadataServiceExporter.export();
            }
        }
    }

    @Override
    public synchronized void onStopped(ApplicationModel scopeModel) {
        if (this.metadataServiceExporter != null && this.metadataServiceExporter.isExported()) {
            try {
                this.metadataServiceExporter.unexport();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onFailure(ApplicationModel scopeModel, Throwable cause) {
    }

    @Override
    public int getPriority() {
        return Integer.MIN_VALUE;
    }
}

