/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.command;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.Map;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.command.QueuedCommand;

public class HeaderQueueCommand
extends QueuedCommand.AbstractQueuedCommand {
    private final Http2Headers headers;
    private final boolean endStream;

    private HeaderQueueCommand(Metadata headers, boolean endStream) {
        this(HeaderQueueCommand.getHttp2Headers(headers), endStream);
    }

    private HeaderQueueCommand(Http2Headers headers, boolean endStream) {
        this.headers = headers;
        this.endStream = endStream;
    }

    public static HeaderQueueCommand createHeaders(Metadata headers, boolean endStream) {
        return new HeaderQueueCommand(HeaderQueueCommand.getHttp2Headers(headers), endStream);
    }

    public static HeaderQueueCommand createHeaders(Metadata headers) {
        return new HeaderQueueCommand(headers, false);
    }

    public static HeaderQueueCommand createHeaders(Http2Headers headers) {
        return new HeaderQueueCommand(headers, false);
    }

    public static HeaderQueueCommand createHeaders(Http2Headers headers, boolean endStream) {
        return new HeaderQueueCommand(headers, endStream);
    }

    public static HeaderQueueCommand createTrailers(Metadata headers) {
        return new HeaderQueueCommand(headers, true);
    }

    public Http2Headers getHeaders() {
        return this.headers;
    }

    public boolean isEndStream() {
        return this.endStream;
    }

    private static Http2Headers getHttp2Headers(Metadata metadata) {
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers(true);
        metadata.forEach(arg_0 -> HeaderQueueCommand.lambda$getHttp2Headers$0((Http2Headers)http2Headers, arg_0));
        return http2Headers;
    }

    @Override
    public void doSend(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.write((Object)new DefaultHttp2HeadersFrame(this.headers, this.endStream), promise);
    }

    private static /* synthetic */ void lambda$getHttp2Headers$0(Http2Headers http2Headers, Map.Entry kv) {
        Http2Headers cfr_ignored_0 = (Http2Headers)http2Headers.set(kv.getKey(), kv.getValue());
    }
}

