/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.command;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import org.apache.dubbo.rpc.protocol.tri.AbstractStream;
import org.apache.dubbo.rpc.protocol.tri.Compressor;
import org.apache.dubbo.rpc.protocol.tri.IdentityCompressor;
import org.apache.dubbo.rpc.protocol.tri.TripleConstant;
import org.apache.dubbo.rpc.protocol.tri.command.QueuedCommand;

public class DataQueueCommand
extends QueuedCommand.AbstractQueuedCommand {
    private final byte[] data;
    private final boolean endStream;
    private final boolean client;

    private DataQueueCommand(byte[] data, boolean endStream, boolean client) {
        this.data = data;
        this.endStream = endStream;
        this.client = client;
    }

    private DataQueueCommand(boolean endStream, boolean client) {
        this(null, endStream, client);
    }

    private DataQueueCommand(boolean endStream) {
        this(null, endStream, false);
    }

    public static DataQueueCommand createGrpcCommand(byte[] data, boolean endStream, boolean client) {
        return new DataQueueCommand(data, endStream, client);
    }

    public static DataQueueCommand createGrpcCommand(boolean endStream) {
        return new DataQueueCommand(endStream);
    }

    @Override
    public void doSend(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.data == null) {
            ctx.write((Object)new DefaultHttp2DataFrame(this.endStream), promise);
        } else {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeByte(this.getCompressFlag(ctx));
            buf.writeInt(this.data.length);
            buf.writeBytes(this.data);
            ctx.write((Object)new DefaultHttp2DataFrame(buf, this.endStream), promise);
        }
    }

    private int getCompressFlag(ChannelHandlerContext ctx) {
        AbstractStream stream = this.client ? (AbstractStream)ctx.channel().attr(TripleConstant.CLIENT_STREAM_KEY).get() : (AbstractStream)ctx.channel().attr(TripleConstant.SERVER_STREAM_KEY).get();
        return this.calcCompressFlag(stream.getCompressor());
    }

    protected int calcCompressFlag(Compressor compressor) {
        if (null == compressor || IdentityCompressor.NONE.equals(compressor)) {
            return 0;
        }
        return 1;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isEndStream() {
        return this.endStream;
    }

    public boolean isClient() {
        return this.client;
    }
}

