/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.DebugInfo;
import com.google.rpc.ErrorInfo;
import com.google.rpc.Status;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.exchange.support.DefaultFuture2;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.tri.AbstractClientStream;
import org.apache.dubbo.rpc.protocol.tri.ClassLoadUtil;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.InboundTransportObserver;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.ServerUnaryInboundTransportObserver;
import org.apache.dubbo.rpc.protocol.tri.Stream;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

public class UnaryClientStream
extends AbstractClientStream
implements Stream {
    protected UnaryClientStream(URL url) {
        super(url);
    }

    @Override
    protected void doOnStartCall() {
        this.inboundMessageObserver().onNext(this.getRpcInvocation());
        this.inboundMessageObserver().onCompleted();
    }

    @Override
    protected InboundTransportObserver createInboundTransportObserver() {
        return new ClientUnaryInboundTransportObserver();
    }

    private Map<Class<?>, Object> tranFromStatusDetails(List<Any> detailList) {
        HashMap map = new HashMap();
        try {
            for (Any any : detailList) {
                if (any.is(ErrorInfo.class)) {
                    ErrorInfo errorInfo = (ErrorInfo)any.unpack(ErrorInfo.class);
                    map.putIfAbsent(ErrorInfo.class, errorInfo);
                    continue;
                }
                if (!any.is(DebugInfo.class)) continue;
                DebugInfo debugInfo = (DebugInfo)any.unpack(DebugInfo.class);
                map.putIfAbsent(DebugInfo.class, debugInfo);
            }
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        return map;
    }

    private class ClientUnaryInboundTransportObserver
    extends ServerUnaryInboundTransportObserver {
        private ClientUnaryInboundTransportObserver() {
        }

        @Override
        public void onComplete() {
            UnaryClientStream.this.execute(() -> {
                GrpcStatus status = this.extractStatusFromMeta(this.getHeaders());
                if (GrpcStatus.Code.isOk(status.code.code)) {
                    try {
                        AppResponse result;
                        if (!Void.TYPE.equals(UnaryClientStream.this.getMethodDescriptor().getReturnClass())) {
                            Object resp = UnaryClientStream.this.deserializeResponse(this.getData());
                            result = new AppResponse(resp);
                        } else {
                            result = new AppResponse();
                        }
                        Response response = new Response(UnaryClientStream.this.getRequestId(), "1.0.0");
                        result.setObjectAttachments(UnaryClientStream.this.parseMetadataToAttachmentMap(this.getTrailers()));
                        response.setResult(result);
                        DefaultFuture2.received(UnaryClientStream.this.getConnection(), response);
                    }
                    catch (Exception e) {
                        GrpcStatus clientStatus = GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withCause(e).withDescription("Failed to deserialize response");
                        this.onError(clientStatus);
                    }
                } else {
                    this.onError(status);
                }
            });
        }

        @Override
        public void onError(GrpcStatus status) {
            Response response = new Response(UnaryClientStream.this.getRequestId(), "1.0.0");
            response.setErrorMessage(status.description);
            AppResponse result = new AppResponse();
            Metadata trailers = this.getTrailers() == null ? this.getHeaders() : this.getTrailers();
            result.setException(this.getThrowable(trailers));
            result.setObjectAttachments(UnaryClientStream.this.parseMetadataToAttachmentMap(trailers));
            response.setResult(result);
            if (!result.hasException()) {
                byte code = GrpcStatus.toDubboStatus(status.code);
                response.setStatus(code);
            }
            DefaultFuture2.received(UnaryClientStream.this.getConnection(), response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Throwable getThrowable(Metadata metadata) {
            if (null == metadata) {
                return null;
            }
            if (!metadata.contains(TripleHeaderEnum.STATUS_DETAIL_KEY.getHeader())) {
                return null;
            }
            CharSequence raw = metadata.get(TripleHeaderEnum.STATUS_DETAIL_KEY.getHeader());
            byte[] statusDetailBin = UnaryClientStream.this.decodeASCIIByte(raw);
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Status statusDetail = UnaryClientStream.this.unpack(statusDetailBin, Status.class);
                List<Any> detailList = statusDetail.getDetailsList();
                Map classObjectMap = UnaryClientStream.this.tranFromStatusDetails(detailList);
                DebugInfo debugInfo = (DebugInfo)classObjectMap.get(DebugInfo.class);
                if (debugInfo == null) {
                    RpcException rpcException = new RpcException(statusDetail.getCode(), statusDetail.getMessage());
                    return rpcException;
                }
                String msg = ExceptionUtils.getStackFrameString((List<String>)debugInfo.getStackEntriesList());
                RpcException rpcException = new RpcException(statusDetail.getCode(), msg);
                return rpcException;
            }
            finally {
                ClassLoadUtil.switchContextLoader(tccl);
            }
        }
    }
}

