/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import grpc.health.v1.HealthCheckResponse;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.PortUnificationExchanger;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.AbstractExporter;
import org.apache.dubbo.rpc.protocol.AbstractProtocol;
import org.apache.dubbo.rpc.protocol.tri.PathResolver;
import org.apache.dubbo.rpc.protocol.tri.TripleInvoker;
import org.apache.dubbo.rpc.protocol.tri.service.TriBuiltinService;

public class TripleProtocol
extends AbstractProtocol
implements Protocol {
    private static final Logger logger = LoggerFactory.getLogger(TripleProtocol.class);
    private final PathResolver pathResolver;
    private final TriBuiltinService triBuiltinService;

    public TripleProtocol(FrameworkModel frameworkModel) {
        this.triBuiltinService = new TriBuiltinService(frameworkModel);
        this.pathResolver = frameworkModel.getExtensionLoader(PathResolver.class).getDefaultExtension();
    }

    @Override
    public int getDefaultPort() {
        return 50051;
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        final URL url = invoker.getUrl();
        final String key = TripleProtocol.serviceKey(url);
        AbstractExporter exporter = new AbstractExporter<T>(invoker){

            @Override
            public void afterUnExport() {
                TripleProtocol.this.pathResolver.remove(url.getServiceKey());
                TripleProtocol.this.pathResolver.remove(url.getServiceInterface());
                TripleProtocol.this.exporterMap.remove(key);
            }
        };
        this.exporterMap.put(key, exporter);
        this.invokers.add(invoker);
        this.pathResolver.add(url.getServiceKey(), invoker);
        this.pathResolver.add(url.getServiceInterface(), invoker);
        this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceKey(), HealthCheckResponse.ServingStatus.SERVING);
        this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceInterface(), HealthCheckResponse.ServingStatus.SERVING);
        PortUnificationExchanger.bind(invoker.getUrl());
        return exporter;
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        TripleInvoker<T> invoker;
        try {
            url = ExecutorUtil.setThreadName(url, "DubboClientHandler");
            url = url.addParameterIfAbsent("threadpool", "cached");
            ExecutorRepository executorRepository = url.getOrDefaultApplicationModel().getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
            executorRepository.createExecutorIfAbsent(url);
            invoker = new TripleInvoker<T>(type, url, this.invokers);
        }
        catch (RemotingException e) {
            throw new RpcException("Fail to create remoting client for service(" + url + "): " + e.getMessage(), (Throwable)e);
        }
        this.invokers.add(invoker);
        return invoker;
    }

    @Override
    protected <T> Invoker<T> protocolBindingRefer(Class<T> type, URL url) throws RpcException {
        return null;
    }

    @Override
    public void destroy() {
        if (logger.isInfoEnabled()) {
            logger.info("Destroying protocol [" + this.getClass().getSimpleName() + "] ...");
        }
        PortUnificationExchanger.close();
        this.pathResolver.destroy();
        super.destroy();
    }
}

