/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.SslContext;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.api.Http2WireProtocol;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;
import org.apache.dubbo.rpc.protocol.tri.GrpcDataDecoder;
import org.apache.dubbo.rpc.protocol.tri.TripleClientHandler;
import org.apache.dubbo.rpc.protocol.tri.TripleClientRequestHandler;
import org.apache.dubbo.rpc.protocol.tri.TripleCommandOutBoundHandler;
import org.apache.dubbo.rpc.protocol.tri.TripleHttp2FrameServerHandler;
import org.apache.dubbo.rpc.protocol.tri.TripleServerConnectionHandler;
import org.apache.dubbo.rpc.protocol.tri.TripleServerInboundHandler;

@Activate
public class TripleHttp2Protocol
extends Http2WireProtocol
implements ScopeModelAware {
    private FrameworkModel frameworkModel;
    private ApplicationModel applicationModel;

    @Override
    public void setFrameworkModel(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void configServerPipeline(URL url, ChannelPipeline pipeline, SslContext sslContext) {
        Configuration config = ConfigurationUtils.getGlobalConfiguration(this.applicationModel);
        Http2FrameCodec codec = Http2FrameCodecBuilder.forServer().gracefulShutdownTimeoutMillis(10000L).initialSettings(new Http2Settings().headerTableSize((long)config.getInt("dubbo.rpc.tri.header-table-size", 4096)).maxConcurrentStreams((long)config.getInt("dubbo.rpc.tri.max-concurrent-streams", Integer.MAX_VALUE)).initialWindowSize(config.getInt("dubbo.rpc.tri.initial-window-size", 0x100000)).maxFrameSize(config.getInt("dubbo.rpc.tri.max-frame-size", 32768)).maxHeaderListSize((long)config.getInt("dubbo.rpc.tri.max-header-list-size", 8192))).frameLogger(SERVER_LOGGER).build();
        Http2MultiplexHandler handler = new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new TripleCommandOutBoundHandler()});
                p.addLast(new ChannelHandler[]{new TripleHttp2FrameServerHandler(TripleHttp2Protocol.this.frameworkModel)});
                p.addLast(new ChannelHandler[]{new GrpcDataDecoder(Integer.MAX_VALUE, false)});
                p.addLast(new ChannelHandler[]{new TripleServerInboundHandler()});
            }
        });
        pipeline.addLast(new ChannelHandler[]{codec, new TripleServerConnectionHandler(), handler});
    }

    @Override
    public void configClientPipeline(URL url, ChannelPipeline pipeline, SslContext sslContext) {
        Configuration config = ConfigurationUtils.getGlobalConfiguration(this.applicationModel);
        Http2FrameCodec codec = Http2FrameCodecBuilder.forClient().gracefulShutdownTimeoutMillis(10000L).initialSettings(new Http2Settings().headerTableSize((long)config.getInt("dubbo.rpc.tri.header-table-size", 4096)).pushEnabled(config.getBoolean("dubbo.rpc.tri.enable-push", false)).maxConcurrentStreams((long)config.getInt("dubbo.rpc.tri.max-concurrent-streams", Integer.MAX_VALUE)).initialWindowSize(config.getInt("dubbo.rpc.tri.initial-window-size", 0x100000)).maxFrameSize(config.getInt("dubbo.rpc.tri.max-frame-size", 32768)).maxHeaderListSize((long)config.getInt("dubbo.rpc.tri.max-header-list-size", 8192))).frameLogger(CLIENT_LOGGER).build();
        Http2MultiplexHandler handler = new Http2MultiplexHandler((ChannelHandler)new TripleClientHandler(this.frameworkModel));
        pipeline.addLast(new ChannelHandler[]{codec, handler, new TripleClientRequestHandler(this.frameworkModel)});
    }
}

