/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.protocol.tri.AbstractServerStream;
import org.apache.dubbo.rpc.protocol.tri.Compressor;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Http2HeaderMeta;
import org.apache.dubbo.rpc.protocol.tri.PathResolver;
import org.apache.dubbo.rpc.protocol.tri.ServerOutboundTransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TripleConstant;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.WriteQueue;
import org.apache.dubbo.rpc.protocol.tri.command.HeaderQueueCommand;
import org.apache.dubbo.rpc.protocol.tri.command.TextDataQueueCommand;
import org.apache.dubbo.rpc.service.ServiceDescriptorInternalCache;

public class TripleHttp2FrameServerHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleHttp2FrameServerHandler.class);
    private final PathResolver pathResolver;
    private final FrameworkModel frameworkModel;

    public TripleHttp2FrameServerHandler(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.pathResolver = frameworkModel.getExtensionLoader(PathResolver.class).getDefaultExtension();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            this.onHeadersRead(ctx, (Http2HeadersFrame)msg);
        } else if (msg instanceof Http2DataFrame) {
            this.onDataRead(ctx, (Http2DataFrame)msg);
        } else if (msg instanceof ReferenceCounted) {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof Http2ResetFrame) {
            this.onResetRead(ctx, (Http2ResetFrame)evt);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void onResetRead(ChannelHandlerContext ctx, Http2ResetFrame frame) {
        AbstractServerStream serverStream = (AbstractServerStream)ctx.channel().attr(TripleConstant.SERVER_STREAM_KEY).get();
        LOGGER.warn("Triple Server received remote reset errorCode=" + frame.errorCode());
        if (serverStream != null) {
            serverStream.cancelByRemote();
        }
        ctx.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Exception in processing triple message", cause);
        }
        GrpcStatus status = GrpcStatus.getStatus(cause, "Provider's error:\n" + cause.getMessage());
        AbstractServerStream serverStream = (AbstractServerStream)ctx.channel().attr(TripleConstant.SERVER_STREAM_KEY).get();
        serverStream.transportError(status, null, true);
    }

    public void onDataRead(ChannelHandlerContext ctx, Http2DataFrame msg) throws Exception {
        AbstractServerStream serverStream;
        super.channelRead(ctx, (Object)msg.content());
        if (msg.isEndStream() && (serverStream = (AbstractServerStream)ctx.channel().attr(TripleConstant.SERVER_STREAM_KEY).get()) != null) {
            serverStream.inboundTransportObserver().onComplete();
        }
    }

    private Invoker<?> getInvoker(Http2Headers headers, String serviceName) {
        String version = headers.contains((Object)TripleHeaderEnum.SERVICE_VERSION.getHeader()) ? ((CharSequence)headers.get((Object)TripleHeaderEnum.SERVICE_VERSION.getHeader())).toString() : null;
        String group = headers.contains((Object)TripleHeaderEnum.SERVICE_GROUP.getHeader()) ? ((CharSequence)headers.get((Object)TripleHeaderEnum.SERVICE_GROUP.getHeader())).toString() : null;
        String key = URL.buildKey(serviceName, group, version);
        Invoker<?> invoker = this.pathResolver.resolve(key);
        if (invoker == null) {
            invoker = this.pathResolver.resolve(serviceName);
        }
        return invoker;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, Http2HeadersFrame msg) throws Exception {
        String compressorStr;
        Http2Headers headers = msg.headers();
        WriteQueue writeQueue = new WriteQueue(ctx.channel());
        ServerOutboundTransportObserver transportObserver = new ServerOutboundTransportObserver(writeQueue);
        if (!HttpMethod.POST.asciiName().contentEquals(headers.method())) {
            this.responsePlainTextError(writeQueue, HttpResponseStatus.METHOD_NOT_ALLOWED.code(), GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription(String.format("Method '%s' is not supported", headers.method())));
            return;
        }
        if (headers.path() == null) {
            this.responsePlainTextError(writeQueue, HttpResponseStatus.NOT_FOUND.code(), GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED.code).withDescription("Expected path but is missing"));
            return;
        }
        String path = headers.path().toString();
        if (path.charAt(0) != '/') {
            this.responsePlainTextError(writeQueue, HttpResponseStatus.NOT_FOUND.code(), GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED.code).withDescription(String.format("Expected path to start with /: %s", path)));
            return;
        }
        CharSequence contentType = HttpUtil.getMimeType((CharSequence)((CharSequence)headers.get((Object)HttpHeaderNames.CONTENT_TYPE)));
        if (contentType == null) {
            this.responsePlainTextError(writeQueue, HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE.code(), GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL.code).withDescription("Content-Type is missing from the request"));
            return;
        }
        String contentString = contentType.toString();
        if (!this.supportContentType(contentString)) {
            this.responsePlainTextError(writeQueue, HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE.code(), GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL.code).withDescription(String.format("Content-Type '%s' is not supported", contentString)));
            return;
        }
        String[] parts = path.split("/");
        if (parts.length != 3) {
            this.responseErr(transportObserver, GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED).withDescription("Bad path format:" + path));
            return;
        }
        String serviceName = parts[1];
        String originalMethodName = parts[2];
        String methodName = Character.toLowerCase(originalMethodName.charAt(0)) + originalMethodName.substring(1);
        Invoker<?> invoker = this.getInvoker(headers, serviceName);
        if (invoker == null) {
            this.responseErr(transportObserver, GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED).withDescription("Service not found:" + serviceName));
            return;
        }
        FrameworkServiceRepository repo = this.frameworkModel.getServiceRepository();
        ProviderModel providerModel = repo.lookupExportedService(invoker.getUrl().getServiceKey());
        if (providerModel == null || providerModel.getServiceModel() == null) {
            this.responseErr(transportObserver, GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED).withDescription("Service not found:" + serviceName));
            return;
        }
        MethodDescriptor methodDescriptor = null;
        List<MethodDescriptor> methodDescriptors = null;
        if (this.isGeneric(methodName)) {
            methodDescriptor = ServiceDescriptorInternalCache.genericService().getMethods(methodName).get(0);
        } else if (this.isEcho(methodName)) {
            methodDescriptor = ServiceDescriptorInternalCache.echoService().getMethods(methodName).get(0);
        } else {
            methodDescriptors = providerModel.getServiceModel().getMethods(methodName);
            if (CollectionUtils.isEmpty(methodDescriptors)) {
                methodDescriptors = providerModel.getServiceModel().getMethods(originalMethodName);
            }
            if (CollectionUtils.isEmpty(methodDescriptors)) {
                this.responseErr(transportObserver, GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED).withDescription("Method :" + methodName + " not found of service:" + serviceName));
                return;
            }
            if (methodDescriptors.size() == 1) {
                methodDescriptor = methodDescriptors.get(0);
            }
        }
        Compressor deCompressor = Compressor.NONE;
        CharSequence messageEncoding = (CharSequence)headers.get((Object)TripleHeaderEnum.GRPC_ENCODING.getHeader());
        if (null != messageEncoding && !"identity".equals(compressorStr = messageEncoding.toString())) {
            Compressor compressor = Compressor.getCompressor(this.frameworkModel, compressorStr);
            if (null == compressor) {
                this.responseErr(transportObserver, GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED.code).withDescription(String.format("Grpc-encoding '%s' is not supported", compressorStr)));
                return;
            }
            deCompressor = compressor;
        }
        boolean isUnary = methodDescriptor == null || methodDescriptor.isUnary();
        AbstractServerStream stream = AbstractServerStream.newServerStream(invoker.getUrl(), isUnary);
        Channel channel = ctx.channel();
        stream.service(providerModel.getServiceModel()).invoker(invoker).methodName(methodName).setDeCompressor(deCompressor).subscribe(transportObserver);
        if (methodDescriptor != null) {
            stream.method(methodDescriptor);
        } else {
            stream.methods(methodDescriptors);
        }
        TransportObserver observer = stream.inboundTransportObserver();
        observer.onMetadata(new Http2HeaderMeta(headers), false);
        if (msg.isEndStream()) {
            observer.onComplete();
        }
        channel.attr(TripleConstant.SERVER_STREAM_KEY).set((Object)stream);
    }

    private boolean supportContentType(String contentType) {
        if (contentType == null) {
            return false;
        }
        return contentType.startsWith("application/grpc");
    }

    private void responsePlainTextError(WriteQueue writeQueue, int code, GrpcStatus status) {
        Http2Headers headers = (Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers(true).status((CharSequence)String.valueOf(code)).setInt((Object)TripleHeaderEnum.STATUS_KEY.getHeader(), status.code.code)).set((Object)TripleHeaderEnum.MESSAGE_KEY.getHeader(), (Object)status.description)).set((Object)TripleHeaderEnum.CONTENT_TYPE_KEY.getHeader(), (Object)"text/plain; encoding=utf-8");
        writeQueue.enqueue(HeaderQueueCommand.createHeaders(headers, false), false);
        writeQueue.enqueue(TextDataQueueCommand.createCommand(status.description, true), true);
    }

    private void responseErr(ServerOutboundTransportObserver observer, GrpcStatus status) {
        Http2Headers trailers = (Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.OK.codeAsText()).set((Object)HttpHeaderNames.CONTENT_TYPE, (Object)"application/grpc+proto")).setInt((Object)TripleHeaderEnum.STATUS_KEY.getHeader(), status.code.code)).set((Object)TripleHeaderEnum.MESSAGE_KEY.getHeader(), (Object)status.toMessage());
        observer.onMetadata(trailers, true);
    }

    private boolean isEcho(String methodName) {
        return "$echo".equals(methodName);
    }

    private boolean isGeneric(String methodName) {
        return "$invoke".equals(methodName) || "$invokeAsync".equals(methodName);
    }
}

