/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.TransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

public abstract class InboundTransportObserver
implements TransportObserver {
    private Metadata headers;
    private Metadata trailers;

    public Metadata getHeaders() {
        return this.headers;
    }

    public Metadata getTrailers() {
        return this.trailers;
    }

    @Override
    public void onMetadata(Metadata metadata, boolean endStream) {
        if (this.headers == null) {
            this.headers = metadata;
        } else {
            this.trailers = metadata;
        }
    }

    protected GrpcStatus extractStatusFromMeta(Metadata metadata) {
        if (!metadata.contains(TripleHeaderEnum.STATUS_KEY.getHeader())) {
            return GrpcStatus.fromCode(GrpcStatus.Code.OK);
        }
        int code = Integer.parseInt(metadata.get(TripleHeaderEnum.STATUS_KEY.getHeader()).toString());
        if (GrpcStatus.Code.isOk(code)) {
            return GrpcStatus.fromCode(GrpcStatus.Code.OK);
        }
        GrpcStatus status = GrpcStatus.fromCode(code);
        if (!metadata.contains(TripleHeaderEnum.MESSAGE_KEY.getHeader())) {
            return status;
        }
        String raw = metadata.get(TripleHeaderEnum.MESSAGE_KEY.getHeader()).toString();
        status = status.withDescription(GrpcStatus.fromMessage(raw));
        return status;
    }
}

