/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.protocol.tri.AbstractClientStream;
import org.apache.dubbo.rpc.protocol.tri.AbstractServerStream;
import org.apache.dubbo.rpc.protocol.tri.AbstractStream;
import org.apache.dubbo.rpc.protocol.tri.Compressor;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.TripleConstant;

public class GrpcDataDecoder
extends ReplayingDecoder<GrpcDecodeState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcDataDecoder.class);
    private static final int RESERVED_MASK = 254;
    private static final int COMPRESSED_FLAG_MASK = 1;
    private final int maxDataSize;
    private final boolean client;
    private int len;
    private boolean compressedFlag;

    public GrpcDataDecoder(int maxDataSize, boolean client) {
        super((Object)GrpcDecodeState.HEADER);
        this.maxDataSize = maxDataSize;
        this.client = client;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Grpc data read error ", cause);
        }
        ctx.close();
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch ((GrpcDecodeState)((Object)this.state())) {
            case HEADER: {
                byte type = in.readByte();
                if ((type & 0xFE) != 0) {
                    throw GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription("gRPC frame header malformed: reserved bits not zero").asException();
                }
                this.compressedFlag = (type & 1) != 0;
                this.len = in.readInt();
                if (this.len < 0 || this.len > this.maxDataSize) {
                    throw GrpcStatus.fromCode(GrpcStatus.Code.RESOURCE_EXHAUSTED).withDescription(String.format("gRPC message exceeds maximum size %d: %d", this.maxDataSize, this.len)).asException();
                }
                this.checkpoint((Object)GrpcDecodeState.PAYLOAD);
            }
            case PAYLOAD: {
                byte[] dst = new byte[this.len];
                in.readBytes(dst);
                out.add(this.decompressData(dst, ctx));
                this.checkpoint((Object)GrpcDecodeState.HEADER);
                break;
            }
            default: {
                throw new RuntimeException("Should not reach here");
            }
        }
    }

    private byte[] decompressData(byte[] data, ChannelHandlerContext ctx) {
        if (!this.compressedFlag) {
            return data;
        }
        Compressor compressor = this.getDeCompressor(ctx, this.client);
        if (null == compressor) {
            throw GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED).withDescription("gRPC message compressor not found").asException();
        }
        return compressor.decompress(data);
    }

    private Compressor getDeCompressor(ChannelHandlerContext ctx, boolean client) {
        AbstractStream stream = client ? this.getClientStream(ctx) : this.getServerStream(ctx);
        return stream.getDeCompressor();
    }

    private AbstractClientStream getClientStream(ChannelHandlerContext ctx) {
        return (AbstractClientStream)ctx.channel().attr(TripleConstant.CLIENT_STREAM_KEY).get();
    }

    private AbstractServerStream getServerStream(ChannelHandlerContext ctx) {
        return (AbstractServerStream)ctx.channel().attr(TripleConstant.SERVER_STREAM_KEY).get();
    }

    static enum GrpcDecodeState {
        HEADER,
        PAYLOAD;

    }
}

