/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.util.Set;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.IdentityCompressor;

@SPI(value="identity", scope=ExtensionScope.FRAMEWORK)
public interface Compressor {
    public static final Compressor NONE = new IdentityCompressor();
    public static final String DEFAULT_COMPRESSOR = "identity";

    public static Compressor getCompressor(FrameworkModel frameworkModel, String compressorStr) {
        if (null == compressorStr) {
            return null;
        }
        if (compressorStr.equals(DEFAULT_COMPRESSOR)) {
            return NONE;
        }
        return frameworkModel.getExtensionLoader(Compressor.class).getExtension(compressorStr);
    }

    public static String getAcceptEncoding(FrameworkModel frameworkModel) {
        Set<String> supportedEncodingSet = frameworkModel.getExtensionLoader(Compressor.class).getSupportedExtensions();
        if (supportedEncodingSet.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)",", supportedEncodingSet);
    }

    public String getMessageEncoding();

    public byte[] compress(byte[] var1);

    public byte[] decompress(byte[] var1);
}

