/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.rpc.CancellationContext;

public abstract class CancelableStreamObserver<T>
implements StreamObserver<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CancelableStreamObserver.class);
    private final AtomicBoolean contextSet = new AtomicBoolean(false);
    private CancellationContext cancellationContext;

    public CancelableStreamObserver() {
    }

    public CancelableStreamObserver(CancellationContext cancellationContext) {
        this.setCancellationContext(cancellationContext);
    }

    public final void setCancellationContext(CancellationContext cancellationContext) {
        if (this.contextSet.compareAndSet(false, true)) {
            this.cancellationContext = cancellationContext;
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("CancellationContext already set,do not repeat the set, ignore this set");
        }
    }

    public final void cancel(Throwable throwable) {
        if (this.cancellationContext == null) {
            return;
        }
        this.cancellationContext.cancel(throwable);
    }
}

