/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.rpc.DebugInfo;
import com.google.rpc.Status;
import io.netty.handler.codec.http2.Http2Headers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.MultipleSerialization;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.serial.SerializingExecutor;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.CancellationContext;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.Compressor;
import org.apache.dubbo.rpc.protocol.tri.DefaultMetadata;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.IdentityCompressor;
import org.apache.dubbo.rpc.protocol.tri.InboundTransportObserver;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.OutboundTransportObserver;
import org.apache.dubbo.rpc.protocol.tri.SingleProtobufUtils;
import org.apache.dubbo.rpc.protocol.tri.Stream;
import org.apache.dubbo.rpc.protocol.tri.TransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TransportState;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

public abstract class AbstractStream
implements Stream {
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder().withoutPadding();
    private final URL url;
    private final MultipleSerialization multipleSerialization;
    private final StreamObserver<Object> inboundMessageObserver;
    private final InboundTransportObserver inboundTransportObserver;
    private final Executor executor;
    private final CancellationContext cancellationContext;
    private final String acceptEncoding;
    private MethodDescriptor methodDescriptor;
    private String methodName;
    private String serializeType;
    private StreamObserver<Object> outboundMessageSubscriber;
    private OutboundTransportObserver outboundTransportObserver;
    private Compressor compressor = IdentityCompressor.NONE;
    private Compressor deCompressor = IdentityCompressor.NONE;
    private volatile boolean cancelled = false;

    protected AbstractStream(URL url) {
        this(url, null);
    }

    protected AbstractStream(URL url, Executor executor) {
        this.url = url;
        Executor sourceExecutor = this.lookupExecutor(url, executor);
        this.executor = this.wrapperSerializingExecutor(sourceExecutor);
        String value = url.getParameter("serialize.multiple", "default");
        this.multipleSerialization = url.getOrDefaultFrameworkModel().getExtensionLoader(MultipleSerialization.class).getExtension(value);
        this.cancellationContext = new CancellationContext();
        this.inboundTransportObserver = this.createInboundTransportObserver();
        this.inboundMessageObserver = this.createStreamObserver();
        this.acceptEncoding = Compressor.getAcceptEncoding(this.getUrl().getOrDefaultFrameworkModel());
    }

    protected abstract void cancelByRemoteReset();

    protected abstract void cancelByLocal(Throwable var1);

    protected abstract StreamObserver<Object> createStreamObserver();

    protected abstract InboundTransportObserver createInboundTransportObserver();

    private void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Executor lookupExecutor(URL url, Executor executor) {
        if (executor != null) {
            return executor;
        }
        ExecutorRepository executorRepository = url.getOrDefaultApplicationModel().getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
        ExecutorService urlExecutor = executorRepository.getExecutor(url);
        if (urlExecutor == null) {
            urlExecutor = executorRepository.createExecutorIfAbsent(url);
        }
        return urlExecutor;
    }

    private Executor wrapperSerializingExecutor(Executor executor) {
        return new SerializingExecutor(executor);
    }

    public String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public TransportState getState() {
        return this.outboundTransportObserver.state;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    protected CancellationContext getCancellationContext() {
        return this.cancellationContext;
    }

    @Override
    public void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public AbstractStream methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public AbstractStream method(MethodDescriptor md) {
        this.methodDescriptor = md;
        this.methodName = md.getMethodName();
        return this;
    }

    protected final void cancel(Throwable cause) {
        this.cancel();
        this.cancelByLocal(cause);
    }

    private void cancel() {
        this.cancelled = true;
    }

    protected final void cancelByRemote() {
        this.cancel();
        this.cancelByRemoteReset();
    }

    public String getSerializeType() {
        return this.serializeType;
    }

    public AbstractStream serialize(String serializeType) {
        if ("hessian4".equals(serializeType)) {
            serializeType = "hessian2";
        }
        this.serializeType = serializeType;
        return this;
    }

    public MultipleSerialization getMultipleSerialization() {
        return this.multipleSerialization;
    }

    public StreamObserver<Object> outboundMessageSubscriber() {
        return this.outboundMessageSubscriber;
    }

    public OutboundTransportObserver outboundTransportObserver() {
        return this.outboundTransportObserver;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    protected AbstractStream setCompressor(Compressor compressor) {
        if (compressor != null) {
            this.compressor = compressor;
        } else if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Compressor is Null, Fall back to default compression. MessageEncoding is " + this.getCompressor().getMessageEncoding());
        }
        return this;
    }

    public Compressor getDeCompressor() {
        return this.deCompressor;
    }

    protected AbstractStream setDeCompressor(Compressor compressor) {
        if (compressor != null) {
            this.deCompressor = compressor;
        } else if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Compressor is Null, Fall back to default deCompression. MessageEncoding is " + this.getDeCompressor().getMessageEncoding());
        }
        return this;
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public void subscribe(StreamObserver<Object> outboundMessageObserver) {
        this.outboundMessageSubscriber = outboundMessageObserver;
    }

    @Override
    public void subscribe(OutboundTransportObserver observer) {
        this.outboundTransportObserver = observer;
    }

    @Override
    public StreamObserver<Object> inboundMessageObserver() {
        return this.inboundMessageObserver;
    }

    @Override
    public TransportObserver inboundTransportObserver() {
        return this.inboundTransportObserver;
    }

    protected void transportError(GrpcStatus status, Map<String, Object> attachments, boolean onlyTrailers) {
        if (!onlyTrailers) {
            DefaultMetadata metadata = new DefaultMetadata();
            this.outboundTransportObserver().onMetadata(metadata, false);
        }
        Metadata trailers = this.getTrailers(status);
        if (attachments != null) {
            this.convertAttachment(trailers, attachments);
        }
        this.outboundTransportObserver().onMetadata(trailers, true);
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("[Triple-Error] status=" + status.code.code + " method=" + this.getMethodName() + " onlyTrailers=" + onlyTrailers, status.cause);
        }
    }

    protected void transportError(GrpcStatus status) {
        this.transportError(status, null, false);
    }

    private String getGrpcMessage(GrpcStatus status) {
        if (StringUtils.isNotEmpty(status.description)) {
            return status.description;
        }
        if (status.cause != null) {
            return status.cause.getMessage();
        }
        return "unknown";
    }

    private Metadata getTrailers(GrpcStatus grpcStatus) {
        DefaultMetadata metadata = new DefaultMetadata();
        metadata.put(TripleHeaderEnum.MESSAGE_KEY.getHeader(), this.getGrpcMessage(grpcStatus));
        metadata.put(TripleHeaderEnum.STATUS_KEY.getHeader(), String.valueOf(grpcStatus.code.code));
        Status.Builder builder = Status.newBuilder().setCode(grpcStatus.code.code).setMessage(this.getGrpcMessage(grpcStatus));
        Throwable throwable = grpcStatus.cause;
        if (throwable == null) {
            Status status = builder.build();
            metadata.put(TripleHeaderEnum.STATUS_DETAIL_KEY.getHeader(), this.encodeBase64ASCII(status.toByteArray()));
            return metadata;
        }
        DebugInfo debugInfo = DebugInfo.newBuilder().addAllStackEntries(ExceptionUtils.getStackFrameList(throwable, 10)).build();
        builder.addDetails(Any.pack((Message)debugInfo));
        Status status = builder.build();
        metadata.put(TripleHeaderEnum.STATUS_DETAIL_KEY.getHeader(), this.encodeBase64ASCII(status.toByteArray()));
        return metadata;
    }

    protected Map<String, Object> parseMetadataToAttachmentMap(Metadata metadata) {
        HashMap<String, Object> attachments = new HashMap<String, Object>();
        for (Map.Entry header : metadata) {
            String key = ((CharSequence)header.getKey()).toString();
            if (Http2Headers.PseudoHeaderName.isPseudoHeader((CharSequence)key) || TripleHeaderEnum.containsExcludeAttachments(key)) continue;
            if (key.endsWith("-bin") && key.length() > "-bin".length()) {
                try {
                    attachments.put(key.substring(0, key.length() - "-bin".length()), this.decodeASCIIByte((CharSequence)header.getValue()));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to parse response attachment key=" + key, e);
                }
                continue;
            }
            attachments.put(key, ((CharSequence)header.getValue()).toString());
        }
        return attachments;
    }

    protected void convertAttachment(Metadata metadata, Map<String, Object> attachments) {
        if (attachments == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : attachments.entrySet()) {
            String key = entry.getKey().toLowerCase(Locale.ROOT);
            if (Http2Headers.PseudoHeaderName.isPseudoHeader((CharSequence)key) || TripleHeaderEnum.containsExcludeAttachments(key)) continue;
            Object v = entry.getValue();
            this.convertSingleAttachment(metadata, key, v);
        }
    }

    private void convertSingleAttachment(Metadata metadata, String key, Object v) {
        try {
            if (v instanceof String) {
                String str = (String)v;
                metadata.put(key, str);
            } else if (v instanceof byte[]) {
                String str = this.encodeBase64ASCII((byte[])v);
                metadata.put(key + "-bin", str);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Meet exception when convert single attachment key:" + key + " value=" + v, t);
        }
    }

    protected String convertHessianFromWrapper(String serializeType) {
        if ("hessian4".equals(serializeType)) {
            return "hessian2";
        }
        return serializeType;
    }

    protected <T> T unpack(byte[] data, Class<T> clz) {
        return this.unpack(new ByteArrayInputStream(data), clz);
    }

    protected <T> T unpack(InputStream is, Class<T> clz) {
        try {
            T req;
            T t = req = SingleProtobufUtils.deserialize(is, clz);
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to unpack req", e);
        }
        finally {
            this.closeQuietly(is);
        }
    }

    protected byte[] pack(Object obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SingleProtobufUtils.serialize(obj, baos);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to pack protobuf object", e);
        }
        return baos.toByteArray();
    }

    protected String encodeBase64ASCII(byte[] in) {
        byte[] bytes = this.encodeBase64(in);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    protected byte[] encodeBase64(byte[] in) {
        return BASE64_ENCODER.encode(in);
    }

    protected byte[] decodeASCIIByte(CharSequence value) {
        return BASE64_DECODER.decode(value.toString().getBytes(StandardCharsets.US_ASCII));
    }

    protected String convertHessianToWrapper(String serializeType) {
        if ("hessian2".equals(serializeType)) {
            return "hessian4";
        }
        return serializeType;
    }

    protected byte[] compress(byte[] data) {
        return this.getCompressor().compress(data);
    }

    protected byte[] decompress(byte[] data) {
        return this.getDeCompressor().decompress(data);
    }
}

