/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider"}, order=-30000)
public class ClassLoaderFilter
implements Filter,
BaseFilter.Listener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        ClassLoader stagedClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader effectiveClassLoader = invoker.getInterface().getClassLoader();
        invocation.put("STAGED_CLASSLOADER", stagedClassLoader);
        invocation.put("WORKING_CLASSLOADER", effectiveClassLoader);
        Thread.currentThread().setContextClassLoader(effectiveClassLoader);
        try {
            Result result = invoker.invoke(invocation);
            return result;
        }
        finally {
            Thread.currentThread().setContextClassLoader(stagedClassLoader);
        }
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        this.resetClassLoader(invoker, invocation);
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        this.resetClassLoader(invoker, invocation);
    }

    private void resetClassLoader(Invoker<?> invoker, Invocation invocation) {
        ClassLoader stagedClassLoader = (ClassLoader)invocation.get("STAGED_CLASSLOADER");
        if (stagedClassLoader != null) {
            Thread.currentThread().setContextClassLoader(stagedClassLoader);
        }
    }
}

