/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.condition;

import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.state.AbstractStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.StateRouterResult;

public class ConditionStateRouter<T>
extends AbstractStateRouter<T> {
    public static final String NAME = "condition";
    private static final Logger logger = LoggerFactory.getLogger(ConditionStateRouter.class);
    protected static final Pattern ROUTE_PATTERN = Pattern.compile("([&!=,]*)\\s*([^&!=,\\s]+)");
    protected static Pattern ARGUMENTS_PATTERN = Pattern.compile("arguments\\[([0-9]+)\\]");
    protected Map<String, MatchPair> whenCondition;
    protected Map<String, MatchPair> thenCondition;
    private boolean enabled;

    public ConditionStateRouter(URL url, String rule, boolean force, boolean enabled) {
        super(url);
        this.setForce(force);
        this.enabled = enabled;
        if (enabled) {
            this.init(rule);
        }
    }

    public ConditionStateRouter(URL url) {
        super(url);
        this.setUrl(url);
        this.setPriority(url.getParameter("priority", 0));
        this.setForce(url.getParameter("force", false));
        this.enabled = url.getParameter("enabled", true);
        if (this.enabled) {
            this.init(url.getParameterAndDecoded("rule"));
        }
    }

    public void init(String rule) {
        try {
            if (rule == null || rule.trim().length() == 0) {
                throw new IllegalArgumentException("Illegal route rule!");
            }
            int i = (rule = rule.replace("consumer.", "").replace("provider.", "")).indexOf("=>");
            String whenRule = i < 0 ? null : rule.substring(0, i).trim();
            String thenRule = i < 0 ? rule.trim() : rule.substring(i + 2).trim();
            HashMap<String, MatchPair> when = StringUtils.isBlank(whenRule) || "true".equals(whenRule) ? new HashMap<String, MatchPair>() : ConditionStateRouter.parseRule(whenRule);
            Map<String, MatchPair> then = StringUtils.isBlank(thenRule) || "false".equals(thenRule) ? null : ConditionStateRouter.parseRule(thenRule);
            this.whenCondition = when;
            this.thenCondition = then;
        }
        catch (ParseException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static Map<String, MatchPair> parseRule(String rule) throws ParseException {
        HashMap<String, MatchPair> condition = new HashMap<String, MatchPair>();
        if (StringUtils.isBlank(rule)) {
            return condition;
        }
        MatchPair pair = null;
        Set<String> values = null;
        Matcher matcher = ROUTE_PATTERN.matcher(rule);
        while (matcher.find()) {
            String separator = matcher.group(1);
            String content = matcher.group(2);
            if (StringUtils.isEmpty(separator)) {
                pair = new MatchPair();
                condition.put(content, pair);
                continue;
            }
            if ("&".equals(separator)) {
                if (condition.get(content) == null) {
                    pair = new MatchPair();
                    condition.put(content, pair);
                    continue;
                }
                pair = (MatchPair)condition.get(content);
                continue;
            }
            if ("=".equals(separator)) {
                if (pair == null) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values = pair.matches;
                values.add(content);
                continue;
            }
            if ("!=".equals(separator)) {
                if (pair == null) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values = pair.mismatches;
                values.add(content);
                continue;
            }
            if (",".equals(separator)) {
                if (values == null || values.isEmpty()) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values.add(content);
                continue;
            }
            throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
        }
        return condition;
    }

    @Override
    public StateRouterResult<Invoker<T>> route(BitList<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage) throws RpcException {
        if (!this.enabled) {
            return new StateRouterResult<Invoker<T>>(invokers, needToPrintMessage ? "Directly return. Reason: ConditionRouter disabled." : null);
        }
        if (CollectionUtils.isEmpty(invokers)) {
            return new StateRouterResult<Invoker<T>>(invokers, needToPrintMessage ? "Directly return. Reason: Invokers from previous router is empty." : null);
        }
        try {
            if (!this.matchWhen(url, invocation)) {
                return new StateRouterResult<Invoker<T>>(invokers, needToPrintMessage ? "Directly return. Reason: WhenCondition not match." : null);
            }
            if (this.thenCondition == null) {
                logger.warn("The current consumer in the service blacklist. consumer: " + NetUtils.getLocalHost() + ", service: " + url.getServiceKey());
                return new StateRouterResult<Invoker<T>>(BitList.emptyList(), needToPrintMessage ? "Empty return. Reason: ThenCondition is empty." : null);
            }
            Object result = invokers.clone();
            result.removeIf(invoker -> !this.matchThen(invoker.getUrl(), url));
            if (!((AbstractCollection)result).isEmpty()) {
                return new StateRouterResult<Invoker<T>>(result, needToPrintMessage ? "Match return." : null);
            }
            if (this.isForce()) {
                logger.warn("The route result is empty and force execute. consumer: " + NetUtils.getLocalHost() + ", service: " + url.getServiceKey() + ", router: " + url.getParameterAndDecoded("rule"));
                return new StateRouterResult<Invoker<T>>(result, needToPrintMessage ? "Empty return. Reason: Empty result from condition and condition is force." : null);
            }
        }
        catch (Throwable t) {
            logger.error("Failed to execute condition router rule: " + this.getUrl() + ", invokers: " + invokers + ", cause: " + t.getMessage(), t);
        }
        return new StateRouterResult<Invoker<T>>(invokers, needToPrintMessage ? "Directly return. Reason: Error occurred ( or result is empty )." : null);
    }

    @Override
    public boolean isRuntime() {
        return this.getUrl().getParameter("runtime", false);
    }

    boolean matchWhen(URL url, Invocation invocation) {
        return CollectionUtils.isEmptyMap(this.whenCondition) || this.matchCondition(this.whenCondition, url, null, invocation);
    }

    private boolean matchThen(URL url, URL param) {
        return CollectionUtils.isNotEmptyMap(this.thenCondition) && this.matchCondition(this.thenCondition, url, param, null);
    }

    private boolean matchCondition(Map<String, MatchPair> condition, URL url, URL param, Invocation invocation) {
        Map<String, String> sample = url.toMap();
        boolean result = false;
        for (Map.Entry<String, MatchPair> matchPair : condition.entrySet()) {
            String key = matchPair.getKey();
            if (key.startsWith("arguments")) {
                if (!this.matchArguments(matchPair, invocation)) {
                    return false;
                }
                result = true;
                continue;
            }
            String sampleValue = invocation != null && ("method".equals(key) || "methods".equals(key)) ? invocation.getMethodName() : ("address".equals(key) ? url.getAddress() : ("host".equals(key) ? url.getHost() : sample.get(key)));
            if (sampleValue != null) {
                if (!matchPair.getValue().isMatch(sampleValue, param)) {
                    return false;
                }
                result = true;
                continue;
            }
            if (!matchPair.getValue().matches.isEmpty()) {
                return false;
            }
            result = true;
        }
        return result;
    }

    public boolean matchArguments(Map.Entry<String, MatchPair> matchPair, Invocation invocation) {
        try {
            String key = matchPair.getKey();
            String[] expressArray = key.split("\\.");
            String argumentExpress = expressArray[0];
            Matcher matcher = ARGUMENTS_PATTERN.matcher(argumentExpress);
            if (!matcher.find()) {
                return false;
            }
            int index = Integer.parseInt(matcher.group(1));
            if (index < 0 || index > invocation.getArguments().length) {
                return false;
            }
            Object object = invocation.getArguments()[index];
            if (matchPair.getValue().isMatch(String.valueOf(object), null)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.warn("Arguments match failed, matchPair[]" + matchPair + "] invocation[" + invocation + "]", e);
        }
        return false;
    }

    protected static final class MatchPair {
        final Set<String> matches = new HashSet<String>();
        final Set<String> mismatches = new HashSet<String>();

        protected MatchPair() {
        }

        private boolean isMatch(String value, URL param) {
            if (!this.matches.isEmpty() && this.mismatches.isEmpty()) {
                for (String match : this.matches) {
                    if (!UrlUtils.isMatchGlobPattern(match, value, param)) continue;
                    return true;
                }
                return false;
            }
            if (!this.mismatches.isEmpty() && this.matches.isEmpty()) {
                for (String mismatch : this.mismatches) {
                    if (!UrlUtils.isMatchGlobPattern(mismatch, value, param)) continue;
                    return false;
                }
                return true;
            }
            if (!this.matches.isEmpty() && !this.mismatches.isEmpty()) {
                for (String mismatch : this.mismatches) {
                    if (!UrlUtils.isMatchGlobPattern(mismatch, value, param)) continue;
                    return false;
                }
                for (String match : this.matches) {
                    if (!UrlUtils.isMatchGlobPattern(match, value, param)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

