/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.filter.support;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcContextAttachment;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.ZoneDetector;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate(group={"consumer"}, value={"cluster:zone-aware"})
public class ZoneAwareFilter
implements ClusterFilter {
    private ApplicationModel applicationModel;

    public ZoneAwareFilter(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RpcContextAttachment rpcContext = RpcContext.getClientAttachment();
        String zone = ((RpcContext)rpcContext).getAttachment("registry_zone");
        String force = ((RpcContext)rpcContext).getAttachment("registry_zone_force");
        ExtensionLoader<ZoneDetector> loader = this.applicationModel.getExtensionLoader(ZoneDetector.class);
        if (StringUtils.isEmpty(zone) && loader.hasExtension("default")) {
            ZoneDetector detector = loader.getExtension("default");
            zone = detector.getZoneOfCurrentRequest(invocation);
            force = detector.isZoneForcingEnabled(invocation, zone);
        }
        if (StringUtils.isNotEmpty(zone)) {
            invocation.setAttachment("registry_zone", zone);
        }
        if (StringUtils.isNotEmpty(force)) {
            invocation.setAttachment("registry_zone_force", force);
        }
        return invoker.invoke(invocation);
    }
}

