/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.RouterFactory;
import org.apache.dubbo.rpc.cluster.router.RouterResult;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotNode;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.StateRouter;
import org.apache.dubbo.rpc.cluster.router.state.StateRouterFactory;
import org.apache.dubbo.rpc.cluster.router.state.StateRouterResult;

public class RouterChain<T> {
    private static final Logger logger = LoggerFactory.getLogger(RouterChain.class);
    private volatile BitList<Invoker<T>> invokers = BitList.emptyList();
    private volatile List<Router> routers = Collections.emptyList();
    private volatile List<Router> builtinRouters = Collections.emptyList();
    private volatile List<StateRouter<T>> builtinStateRouters = Collections.emptyList();
    private volatile List<StateRouter<T>> stateRouters = Collections.emptyList();

    public static <T> RouterChain<T> buildChain(Class<T> interfaceClass, URL url) {
        return new RouterChain<T>(interfaceClass, url);
    }

    private RouterChain(Class<T> interfaceClass, URL url) {
        List<RouterFactory> extensionFactories = url.getOrDefaultApplicationModel().getExtensionLoader(RouterFactory.class).getActivateExtension(url, "router");
        List<Router> routers = extensionFactories.stream().map(factory -> factory.getRouter(url)).sorted(Router::compareTo).collect(Collectors.toList());
        this.initWithRouters(routers);
        List<StateRouterFactory> extensionStateRouterFactories = url.getOrDefaultApplicationModel().getExtensionLoader(StateRouterFactory.class).getActivateExtension(url, "router");
        List<StateRouter<T>> stateRouters = extensionStateRouterFactories.stream().map(factory -> factory.getRouter(interfaceClass, url)).sorted(StateRouter::compareTo).collect(Collectors.toList());
        this.initWithStateRouters(stateRouters);
    }

    public void initWithRouters(List<Router> builtinRouters) {
        this.builtinRouters = builtinRouters;
        this.routers = new ArrayList<Router>(builtinRouters);
    }

    public void initWithStateRouters(List<StateRouter<T>> builtinRouters) {
        this.builtinStateRouters = builtinRouters;
        this.setStateRouters(this.builtinStateRouters);
    }

    private void setStateRouters(List<StateRouter<T>> stateRouters) {
        this.stateRouters = new ArrayList<StateRouter<T>>(stateRouters);
    }

    public void addRouters(List<Router> routers) {
        ArrayList<Router> newRouters = new ArrayList<Router>();
        newRouters.addAll(this.builtinRouters);
        newRouters.addAll(routers);
        CollectionUtils.sort(newRouters);
        this.routers = newRouters;
    }

    public void addStateRouters(List<StateRouter<T>> stateRouters) {
        ArrayList<StateRouter<T>> newStateRouters = new ArrayList<StateRouter<T>>();
        newStateRouters.addAll(this.builtinStateRouters);
        newStateRouters.addAll(stateRouters);
        CollectionUtils.sort(newStateRouters);
        this.setStateRouters(newStateRouters);
    }

    public List<Router> getRouters() {
        return this.routers;
    }

    public List<StateRouter<T>> getStateRouters() {
        return this.stateRouters;
    }

    public List<Invoker<T>> route(URL url, BitList<Invoker<T>> availableInvokers, Invocation invocation) {
        BitList<Invoker<T>> resultInvokers = availableInvokers.clone();
        for (StateRouter<T> stateRouter : this.stateRouters) {
            StateRouterResult<Invoker<T>> routeResult = stateRouter.route(resultInvokers, url, invocation, false);
            resultInvokers = routeResult.getResult();
            if (resultInvokers.isEmpty()) {
                this.printRouterSnapshot(url, availableInvokers, invocation);
                return BitList.emptyList();
            }
            if (routeResult.isNeedContinueRoute()) continue;
            return routeResult.getResult();
        }
        if (this.routers.isEmpty()) {
            return resultInvokers;
        }
        List<Invoker<T>> commonRouterResult = new ArrayList<Invoker<T>>(resultInvokers);
        for (Router router : this.routers) {
            RouterResult<Invoker<T>> routeResult = router.route(commonRouterResult, url, invocation, false);
            commonRouterResult = routeResult.getResult();
            if (CollectionUtils.isEmpty(commonRouterResult)) {
                this.printRouterSnapshot(url, availableInvokers, invocation);
                return BitList.emptyList();
            }
            if (routeResult.isNeedContinueRoute()) continue;
            return commonRouterResult;
        }
        return commonRouterResult;
    }

    private void printRouterSnapshot(URL url, BitList<Invoker<T>> availableInvokers, Invocation invocation) {
        this.logRouterSnapshot(url, invocation, this.buildRouterSnapshot(url, availableInvokers, invocation));
    }

    public RouterSnapshotNode<T> buildRouterSnapshot(URL url, BitList<Invoker<T>> availableInvokers, Invocation invocation) {
        BitList<Invoker<T>> resultInvokers = availableInvokers.clone();
        RouterSnapshotNode snapshotNode = new RouterSnapshotNode("Parent", resultInvokers.size());
        snapshotNode.setOutputInvokers(resultInvokers.clone());
        for (StateRouter<T> stateRouter : this.stateRouters) {
            Object inputInvokers = resultInvokers.clone();
            RouterSnapshotNode<T> currentNode = new RouterSnapshotNode<T>(stateRouter.getClass().getSimpleName(), ((BitList)inputInvokers).size());
            snapshotNode.appendNode(currentNode);
            StateRouterResult<Invoker<T>> routeResult = stateRouter.route((BitList<Invoker<T>>)inputInvokers, url, invocation, true);
            resultInvokers = routeResult.getResult();
            String routerMessage = routeResult.getMessage();
            currentNode.setOutputInvokers(resultInvokers);
            currentNode.setRouterMessage(routerMessage);
            if (resultInvokers.isEmpty()) {
                return snapshotNode;
            }
            if (routeResult.isNeedContinueRoute()) continue;
            return snapshotNode;
        }
        List<Invoker<T>> commonRouterResult = resultInvokers;
        for (Router router : this.routers) {
            ArrayList inputInvokers = new ArrayList(commonRouterResult);
            RouterSnapshotNode currentNode = new RouterSnapshotNode(router.getClass().getSimpleName(), inputInvokers.size());
            snapshotNode.appendNode(currentNode);
            RouterResult routeStateResult = router.route(inputInvokers, url, invocation, true);
            List routeResult = routeStateResult.getResult();
            String routerMessage = routeStateResult.getMessage();
            currentNode.setOutputInvokers(routeResult);
            currentNode.setRouterMessage(routerMessage);
            if (CollectionUtils.isEmpty(routeResult)) {
                return snapshotNode;
            }
            commonRouterResult = routeResult;
            if (routeStateResult.isNeedContinueRoute()) continue;
            return snapshotNode;
        }
        return snapshotNode;
    }

    private void logRouterSnapshot(URL url, Invocation invocation, RouterSnapshotNode<T> snapshotNode) {
        logger.warn("No provider available after route for the service " + url.getServiceKey() + " from registry " + url.getAddress() + " on the consumer " + NetUtils.getLocalHost() + " using the dubbo version " + Version.getVersion() + ". Router snapshot is below: \n" + snapshotNode.toString());
    }

    public void setInvokers(BitList<Invoker<T>> invokers) {
        this.invokers = invokers == null ? BitList.emptyList() : invokers;
        this.routers.forEach(router -> router.notify(this.invokers));
        this.stateRouters.forEach(router -> router.notify(this.invokers));
    }

    public void destroy() {
        this.invokers = BitList.emptyList();
        for (Router router : this.routers) {
            try {
                router.stop();
            }
            catch (Exception e) {
                logger.error("Error trying to stop router " + router.getClass(), e);
            }
        }
        this.routers = Collections.emptyList();
        this.builtinRouters = Collections.emptyList();
        for (StateRouter stateRouter : this.stateRouters) {
            try {
                stateRouter.stop();
            }
            catch (Exception e) {
                logger.error("Error trying to stop stateRouter " + stateRouter.getClass(), e);
            }
        }
        this.setStateRouters(Collections.emptyList());
        this.builtinStateRouters = Collections.emptyList();
    }
}

