/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange.support;

import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.resource.GlobalResourceInitializer;
import org.apache.dubbo.common.threadpool.ThreadlessExecutor;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.timer.Timeout;
import org.apache.dubbo.common.timer.Timer;
import org.apache.dubbo.common.timer.TimerTask;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.remoting.api.Connection;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;

public class DefaultFuture2
extends CompletableFuture<Object> {
    private static final GlobalResourceInitializer<Timer> TIME_OUT_TIMER = new GlobalResourceInitializer<Timer>(() -> new HashedWheelTimer(new NamedThreadFactory("dubbo-future-timeout", true), 30L, TimeUnit.MILLISECONDS), DefaultFuture2::destroy);
    private static final Logger logger = LoggerFactory.getLogger(DefaultFuture2.class);
    private static final Map<Long, DefaultFuture2> FUTURES = new ConcurrentHashMap<Long, DefaultFuture2>();
    private final Request request;
    private final Connection connection;
    private final int timeout;
    private final long start = System.currentTimeMillis();
    private final List<Runnable> timeoutListeners = new ArrayList<Runnable>();
    private volatile long sent;
    private Timeout timeoutCheckTask;
    private ExecutorService executor;

    private DefaultFuture2(Connection client2, Request request, int timeout) {
        this.connection = client2;
        this.request = request;
        this.timeout = timeout;
        FUTURES.put(request.getId(), this);
    }

    public static void addTimeoutListener(long id, Runnable runnable) {
        DefaultFuture2 defaultFuture2 = FUTURES.get(id);
        defaultFuture2.addTimeoutListener(runnable);
    }

    private static void timeoutCheck(DefaultFuture2 future) {
        TimeoutCheckTask task = new TimeoutCheckTask(future.getId());
        future.timeoutCheckTask = ((Timer)TIME_OUT_TIMER.get()).newTimeout(task, future.getTimeout(), TimeUnit.MILLISECONDS);
    }

    public static void destroy() {
        TIME_OUT_TIMER.remove(Timer::stop);
        FUTURES.clear();
    }

    public static DefaultFuture2 newFuture(Connection connection, Request request, int timeout, ExecutorService executor) {
        DefaultFuture2 future = new DefaultFuture2(connection, request, timeout);
        future.setExecutor(executor);
        if (executor instanceof ThreadlessExecutor) {
            ((ThreadlessExecutor)executor).setWaitingFuture(future);
        }
        DefaultFuture2.timeoutCheck(future);
        return future;
    }

    public static DefaultFuture2 getFuture(long id) {
        return FUTURES.get(id);
    }

    public static void sent(Request request) {
        DefaultFuture2 future = FUTURES.get(request.getId());
        if (future != null) {
            future.doSent();
        }
    }

    public static void received(Connection connection, Response response) {
        DefaultFuture2.received(connection, response, false);
    }

    public static void received(Connection connection, Response response, boolean timeout) {
        DefaultFuture2 future = FUTURES.remove(response.getId());
        if (future != null) {
            Timeout t = future.timeoutCheckTask;
            if (!timeout) {
                t.cancel();
            }
            future.doReceived(response);
        } else {
            logger.warn("The timeout response finally returned at " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + ", response status is " + response.getStatus() + (connection == null ? "" : ", channel: " + connection.getChannel().localAddress() + " -> " + connection.getRemote()) + ", please check provider side for detailed result.");
        }
    }

    public void addTimeoutListener(Runnable runnable) {
        this.timeoutListeners.add(runnable);
    }

    public List<Runnable> getTimeoutListeners() {
        return this.timeoutListeners;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Response errorResult = new Response(this.request.getId());
        errorResult.setStatus((byte)90);
        errorResult.setErrorMessage("request future has been canceled.");
        this.doReceived(errorResult);
        FUTURES.remove(this.request.getId());
        this.timeoutCheckTask.cancel();
        return true;
    }

    public void cancel() {
        this.cancel(true);
    }

    private void doReceived(Response res) {
        ThreadlessExecutor threadlessExecutor;
        if (res == null) {
            throw new IllegalStateException("response cannot be null");
        }
        if (res.getStatus() == 20) {
            this.complete(res.getResult());
        } else if (res.getStatus() == 30 || res.getStatus() == 31) {
            this.completeExceptionally(new TimeoutException(res.getStatus() == 31, null, this.connection.getRemote(), res.getErrorMessage()));
        } else if (this.connection.getChannel() != null) {
            InetSocketAddress local = (InetSocketAddress)this.connection.getChannel().localAddress();
            this.completeExceptionally(new RemotingException(local, this.connection.getRemote(), res.getErrorMessage()));
        } else {
            this.completeExceptionally(new RemotingException(null, this.connection.getRemote(), res.getErrorMessage()));
        }
        if (this.executor != null && this.executor instanceof ThreadlessExecutor && (threadlessExecutor = (ThreadlessExecutor)this.executor).isWaiting()) {
            threadlessExecutor.notifyReturn(new IllegalStateException("The result has returned, but the biz thread is still waiting which is not an expected state, interrupt the thread manually by returning an exception."));
        }
    }

    private long getId() {
        return this.request.getId();
    }

    private Connection getConnection() {
        return this.connection;
    }

    private boolean isSent() {
        return this.sent > 0L;
    }

    private int getTimeout() {
        return this.timeout;
    }

    private void doSent() {
        this.sent = System.currentTimeMillis();
    }

    private String getTimeoutMessage(boolean scan) {
        long nowTimestamp = System.currentTimeMillis();
        return (this.sent > 0L ? "Waiting server-side response timeout" : "Sending request timeout in client-side") + (scan ? " by scan timer" : "") + ". start time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.start)) + ", end time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(nowTimestamp)) + "," + (this.sent > 0L ? " client elapsed: " + (this.sent - this.start) + " ms, server elapsed: " + (nowTimestamp - this.sent) : " elapsed: " + (nowTimestamp - this.start)) + " ms, timeout: " + this.timeout + " ms, request: " + (logger.isDebugEnabled() ? this.request : this.getRequestWithoutData()) + ", channel: " + this.connection.getChannel();
    }

    private Request getRequestWithoutData() {
        Request newRequest = this.request;
        newRequest.setData(null);
        return newRequest;
    }

    private static class TimeoutCheckTask
    implements TimerTask {
        private final Long requestID;

        TimeoutCheckTask(Long requestID) {
            this.requestID = requestID;
        }

        @Override
        public void run(Timeout timeout) {
            DefaultFuture2 future = DefaultFuture2.getFuture(this.requestID);
            if (future == null || future.isDone()) {
                return;
            }
            if (future.getExecutor() != null) {
                future.getExecutor().execute(() -> {
                    this.notifyTimeout(future);
                    for (Runnable timeoutListener : future.getTimeoutListeners()) {
                        timeoutListener.run();
                    }
                });
            } else {
                this.notifyTimeout(future);
            }
        }

        private void notifyTimeout(DefaultFuture2 future) {
            Response timeoutResponse = new Response(future.getId());
            timeoutResponse.setStatus(future.isSent() ? (byte)31 : 30);
            timeoutResponse.setErrorMessage(future.getTimeoutMessage(true));
            DefaultFuture2.received(future.getConnection(), timeoutResponse, true);
        }
    }
}

