/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds.util;

import io.envoyproxy.envoy.api.v2.DeltaDiscoveryRequest;
import io.envoyproxy.envoy.api.v2.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc;
import io.envoyproxy.envoy.service.discovery.v3.DeltaDiscoveryResponse;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.xds.XdsCertificateSigner;

public class XdsChannel {
    private final ManagedChannel channel;
    private static final Logger logger = LoggerFactory.getLogger(XdsChannel.class);

    protected XdsChannel(URL url) {
        ManagedChannel channel1 = null;
        try {
            XdsCertificateSigner signer = url.getOrDefaultApplicationModel().getExtensionLoader(XdsCertificateSigner.class).getExtension(url.getParameter("Signer", "istio"));
            XdsCertificateSigner.CertPair certPair = signer.request(url);
            SslContext context = GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).keyManager((InputStream)new ByteArrayInputStream(certPair.getPublicKey().getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream(certPair.getPrivateKey().getBytes(StandardCharsets.UTF_8))).build();
            channel1 = NettyChannelBuilder.forAddress((String)url.getHost(), (int)url.getPort()).sslContext(context).build();
        }
        catch (SSLException e) {
            logger.error("Error occurred when creating gRPC channel to control panel.", e);
        }
        this.channel = channel1;
    }

    public StreamObserver<io.envoyproxy.envoy.service.discovery.v3.DeltaDiscoveryRequest> observeDeltaDiscoveryRequest(StreamObserver<DeltaDiscoveryResponse> observer) {
        return AggregatedDiscoveryServiceGrpc.newStub((Channel)this.channel).deltaAggregatedResources(observer);
    }

    public StreamObserver<io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest> createDeltaDiscoveryRequest(StreamObserver<DiscoveryResponse> observer) {
        return AggregatedDiscoveryServiceGrpc.newStub((Channel)this.channel).streamAggregatedResources(observer);
    }

    public StreamObserver<DeltaDiscoveryRequest> observeDeltaDiscoveryRequestV2(StreamObserver<io.envoyproxy.envoy.api.v2.DeltaDiscoveryResponse> observer) {
        return io.envoyproxy.envoy.service.discovery.v2.AggregatedDiscoveryServiceGrpc.newStub((Channel)this.channel).deltaAggregatedResources(observer);
    }

    public StreamObserver<DiscoveryRequest> createDeltaDiscoveryRequestV2(StreamObserver<io.envoyproxy.envoy.api.v2.DiscoveryResponse> observer) {
        return io.envoyproxy.envoy.service.discovery.v2.AggregatedDiscoveryServiceGrpc.newStub((Channel)this.channel).streamAggregatedResources(observer);
    }

    public void destroy() {
        this.channel.shutdown();
    }
}

