/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.url.component.DubboServiceAddressURL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.RegistryNotifier;
import org.apache.dubbo.registry.nacos.NacosNamingServiceWrapper;
import org.apache.dubbo.registry.nacos.NacosServiceName;
import org.apache.dubbo.registry.nacos.util.NacosInstanceManageUtil;
import org.apache.dubbo.registry.support.FailbackRegistry;
import org.apache.dubbo.rpc.RpcException;

public class NacosRegistry
extends FailbackRegistry {
    private static final List<String> ALL_SUPPORTED_CATEGORIES = Arrays.asList("providers", "consumers", "routers", "configurators");
    private static final int CATEGORY_INDEX = 0;
    private static final int SERVICE_INTERFACE_INDEX = 1;
    private static final int SERVICE_VERSION_INDEX = 2;
    private static final int SERVICE_GROUP_INDEX = 3;
    private static final String WILDCARD = "*";
    private static final String UP = "UP";
    private static final String SERVICE_NAME_SEPARATOR = System.getProperty("nacos.service.name.separator", ":");
    private static final int PAGINATION_SIZE = Integer.getInteger("nacos.service.names.pagination.size", 100);
    private static final long LOOKUP_INTERVAL = Long.getLong("nacos.service.names.lookup.interval", 30L);
    private static final Logger logger = LoggerFactory.getLogger(NacosRegistry.class);
    private final NacosNamingServiceWrapper namingService;
    private volatile ScheduledExecutorService scheduledExecutorService;
    private final ConcurrentMap<URL, ConcurrentMap<NotifyListener, ConcurrentMap<String, EventListener>>> nacosListeners = new ConcurrentHashMap<URL, ConcurrentMap<NotifyListener, ConcurrentMap<String, EventListener>>>();

    public NacosRegistry(URL url, NacosNamingServiceWrapper namingService) {
        super(url);
        this.namingService = namingService;
    }

    @Override
    public boolean isAvailable() {
        return UP.equals(this.namingService.getServerStatus());
    }

    @Override
    public List<URL> lookup(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("lookup url == null");
        }
        try {
            LinkedList<URL> urls = new LinkedList<URL>();
            Set<String> serviceNames = this.getServiceNames(url, null);
            for (String serviceName : serviceNames) {
                List<Instance> instances = this.namingService.getAllInstances(serviceName, this.getUrl().getGroup("DEFAULT_GROUP"));
                urls.addAll(this.buildURLs(url, instances));
            }
            return urls;
        }
        catch (Throwable cause) {
            throw new RpcException("Failed to lookup " + url + " from nacos " + this.getUrl() + ", cause: " + cause.getMessage(), cause);
        }
    }

    @Override
    public void doRegister(URL url) {
        try {
            String serviceName = this.getServiceName(url);
            Instance instance = this.createInstance(url);
            this.namingService.registerInstance(serviceName, this.getUrl().getGroup("DEFAULT_GROUP"), instance);
        }
        catch (Throwable cause) {
            throw new RpcException("Failed to register " + url + " to nacos " + this.getUrl() + ", cause: " + cause.getMessage(), cause);
        }
    }

    @Override
    public void doUnregister(URL url) {
        try {
            String serviceName = this.getServiceName(url);
            Instance instance = this.createInstance(url);
            this.namingService.deregisterInstance(serviceName, this.getUrl().getGroup("DEFAULT_GROUP"), instance.getIp(), instance.getPort());
        }
        catch (Throwable cause) {
            throw new RpcException("Failed to unregister " + url + " to nacos " + this.getUrl() + ", cause: " + cause.getMessage(), cause);
        }
    }

    @Override
    public void doSubscribe(URL url, NotifyListener listener) {
        Set<String> serviceNames = this.getServiceNames(url, listener);
        if (this.isServiceNamesWithCompatibleMode(url)) {
            for (String serviceName : serviceNames) {
                NacosInstanceManageUtil.setCorrespondingServiceNames(serviceName, serviceNames);
            }
        }
        this.doSubscribe(url, listener, serviceNames);
    }

    private void doSubscribe(URL url, NotifyListener listener, Set<String> serviceNames) {
        try {
            if (this.isServiceNamesWithCompatibleMode(url)) {
                ArrayList allCorrespondingInstanceList = Lists.newArrayList();
                for (String serviceName : serviceNames) {
                    List<Instance> instances = this.namingService.getAllInstances(serviceName, this.getUrl().getGroup("DEFAULT_GROUP"));
                    NacosInstanceManageUtil.initOrRefreshServiceInstanceList(serviceName, instances);
                    allCorrespondingInstanceList.addAll(instances);
                }
                this.notifySubscriber(url, listener, allCorrespondingInstanceList);
                for (String serviceName : serviceNames) {
                    this.subscribeEventListener(serviceName, url, listener);
                }
            } else {
                for (String serviceName : serviceNames) {
                    LinkedList<Instance> instances = new LinkedList<Instance>();
                    instances.addAll(this.namingService.getAllInstances(serviceName, this.getUrl().getGroup("DEFAULT_GROUP")));
                    String serviceInterface = serviceName;
                    String[] segments = serviceName.split(SERVICE_NAME_SEPARATOR, -1);
                    if (segments.length == 4) {
                        serviceInterface = segments[1];
                    }
                    URL subscriberURL = url.setPath(serviceInterface).addParameters("interface", serviceInterface, "check", String.valueOf(false));
                    this.notifySubscriber(subscriberURL, listener, instances);
                    this.subscribeEventListener(serviceName, subscriberURL, listener);
                }
            }
        }
        catch (Throwable cause) {
            throw new RpcException("Failed to subscribe " + url + " to nacos " + this.getUrl() + ", cause: " + cause.getMessage(), cause);
        }
    }

    private boolean isServiceNamesWithCompatibleMode(URL url) {
        return !this.isAdminProtocol(url) && this.createServiceName(url).isConcrete();
    }

    @Override
    public void doUnsubscribe(URL url, NotifyListener listener) {
        if (this.isAdminProtocol(url)) {
            this.shutdownServiceNamesLookup();
        }
    }

    private void shutdownServiceNamesLookup() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }

    private Set<String> getServiceNames(URL url, NotifyListener listener) {
        if (this.isAdminProtocol(url)) {
            this.scheduleServiceNamesLookup(url, listener);
            return this.getServiceNamesForOps(url);
        }
        return this.getServiceNames0(url);
    }

    private Set<String> getServiceNames0(URL url) {
        LinkedHashSet<String> serviceNames;
        NacosServiceName serviceName = this.createServiceName(url);
        if (serviceName.isConcrete()) {
            serviceNames = new LinkedHashSet();
            serviceNames.add(serviceName.toString());
            String legacySubscribedServiceName = this.getLegacySubscribedServiceName(url);
            if (!serviceName.toString().equals(legacySubscribedServiceName)) {
                serviceNames.add(legacySubscribedServiceName);
            }
        } else {
            serviceNames = this.filterServiceNames(serviceName);
        }
        return serviceNames;
    }

    private Set<String> filterServiceNames(NacosServiceName serviceName) {
        try {
            LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
            serviceNames.addAll(this.namingService.getServicesOfServer(1, Integer.MAX_VALUE, this.getUrl().getGroup("DEFAULT_GROUP")).getData().stream().filter(this::isConformRules).map(NacosServiceName::new).filter(serviceName::isCompatible).map(NacosServiceName::toString).collect(Collectors.toList()));
            return serviceNames;
        }
        catch (Throwable cause) {
            throw new RpcException("Failed to filter serviceName from nacos, url: " + this.getUrl() + ", serviceName: " + serviceName + ", cause: " + cause.getMessage(), cause);
        }
    }

    private boolean isConformRules(String serviceName) {
        return serviceName.split(":", -1).length == 4;
    }

    private String getLegacySubscribedServiceName(URL url) {
        StringBuilder serviceNameBuilder = new StringBuilder("providers");
        this.appendIfPresent(serviceNameBuilder, url, "interface");
        this.appendIfPresent(serviceNameBuilder, url, "version");
        this.appendIfPresent(serviceNameBuilder, url, "group");
        return serviceNameBuilder.toString();
    }

    private void appendIfPresent(StringBuilder target, URL url, String parameterName) {
        String parameterValue = url.getParameter(parameterName);
        if (!StringUtils.isBlank(parameterValue)) {
            target.append(SERVICE_NAME_SEPARATOR).append(parameterValue);
        }
    }

    private boolean isAdminProtocol(URL url) {
        return "admin".equals(url.getProtocol());
    }

    private void scheduleServiceNamesLookup(URL url, NotifyListener listener) {
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                Set<String> serviceNames = this.getAllServiceNames();
                this.filterData(serviceNames, serviceName -> {
                    boolean accepted = false;
                    for (String category : ALL_SUPPORTED_CATEGORIES) {
                        String prefix = category + SERVICE_NAME_SEPARATOR;
                        if (serviceName == null || !serviceName.startsWith(prefix)) continue;
                        accepted = true;
                        break;
                    }
                    return accepted;
                });
                this.doSubscribe(url, listener, serviceNames);
            }, LOOKUP_INTERVAL, LOOKUP_INTERVAL, TimeUnit.SECONDS);
        }
    }

    private Set<String> getServiceNamesForOps(URL url) {
        Set<String> serviceNames = this.getAllServiceNames();
        this.filterServiceNames(serviceNames, url);
        return serviceNames;
    }

    private Set<String> getAllServiceNames() {
        try {
            LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
            int pageIndex = 1;
            ListView<String> listView = this.namingService.getServicesOfServer(pageIndex, PAGINATION_SIZE, this.getUrl().getGroup("DEFAULT_GROUP"));
            List firstPageData = listView.getData();
            serviceNames.addAll(firstPageData);
            int count = listView.getCount();
            int pageNumbers = count / PAGINATION_SIZE;
            int remainder = count % PAGINATION_SIZE;
            if (remainder > 0) {
                ++pageNumbers;
            }
            while (pageIndex < pageNumbers) {
                listView = this.namingService.getServicesOfServer(++pageIndex, PAGINATION_SIZE, this.getUrl().getGroup("DEFAULT_GROUP"));
                serviceNames.addAll(listView.getData());
            }
            return serviceNames;
        }
        catch (Throwable cause) {
            throw new RpcException("Failed to get all serviceName from nacos, url: " + this.getUrl() + ", cause: " + cause.getMessage(), cause);
        }
    }

    private void filterServiceNames(Set<String> serviceNames, URL url) {
        List<String> categories = this.getCategories(url);
        String targetServiceInterface = url.getServiceInterface();
        String targetVersion = url.getVersion("");
        String targetGroup = url.getGroup("");
        this.filterData(serviceNames, serviceName -> {
            String[] segments = serviceName.split(SERVICE_NAME_SEPARATOR, -1);
            int length = segments.length;
            if (length != 4) {
                return false;
            }
            String category = segments[0];
            if (!categories.contains(category)) {
                return false;
            }
            String serviceInterface = segments[1];
            if (!WILDCARD.equals(targetServiceInterface) && !StringUtils.isEquals(targetServiceInterface, serviceInterface)) {
                return false;
            }
            String version = segments[2];
            if (!WILDCARD.equals(targetVersion) && !StringUtils.isEquals(targetVersion, version)) {
                return false;
            }
            String group = segments[3];
            return group == null || WILDCARD.equals(targetGroup) || StringUtils.isEquals(targetGroup, group);
        });
    }

    private <T> void filterData(Collection<T> collection, NacosDataFilter<T> filter) {
        collection.removeIf(data -> !filter.accept(data));
    }

    @Deprecated
    private List<String> doGetServiceNames(URL url) {
        List<String> categories = this.getCategories(url);
        ArrayList<String> serviceNames = new ArrayList<String>(categories.size());
        for (String category : categories) {
            String serviceName = this.getServiceName(url, category);
            serviceNames.add(serviceName);
        }
        return serviceNames;
    }

    private List<URL> toUrlWithEmpty(URL consumerURL, Collection<Instance> instances) {
        List<URL> urls = this.buildURLs(consumerURL, instances);
        if (urls.size() == 0 && !this.getUrl().getParameter("enable-empty-protection", true)) {
            logger.warn("Received empty url address list and empty protection is disabled, will clear current available addresses");
            ServiceConfigURL empty = URLBuilder.from(consumerURL).setProtocol("empty").addParameter("category", "providers").build();
            urls.add(empty);
        }
        return urls;
    }

    private List<URL> buildURLs(URL consumerURL, Collection<Instance> instances) {
        LinkedList<URL> urls = new LinkedList<URL>();
        if (instances != null && !instances.isEmpty()) {
            for (Instance instance : instances) {
                URL url = this.buildURL(consumerURL, instance);
                if (!UrlUtils.isMatch(consumerURL, url)) continue;
                urls.add(url);
            }
        }
        return urls;
    }

    private void subscribeEventListener(String serviceName, URL url, NotifyListener listener) throws NacosException {
        ConcurrentMap listeners = this.nacosListeners.computeIfAbsent(url, k -> new ConcurrentHashMap());
        ConcurrentMap eventListeners = listeners.computeIfAbsent(listener, k -> new ConcurrentHashMap());
        EventListener eventListener = eventListeners.computeIfAbsent(serviceName, k -> new RegistryChildListenerImpl(serviceName, url, listener));
        this.namingService.subscribe(serviceName, this.getUrl().getGroup("DEFAULT_GROUP"), eventListener);
    }

    private void notifySubscriber(URL url, NotifyListener listener, Collection<Instance> instances) {
        LinkedList<Instance> enabledInstances = new LinkedList<Instance>(instances);
        if (enabledInstances.size() > 0) {
            this.filterEnabledInstances(enabledInstances);
        }
        List<URL> urls = this.toUrlWithEmpty(url, enabledInstances);
        this.notify(url, listener, urls);
    }

    private List<String> getCategories(URL url) {
        return WILDCARD.equals(url.getServiceInterface()) ? ALL_SUPPORTED_CATEGORIES : Arrays.asList("providers");
    }

    private URL buildURL(URL consumerURL, Instance instance) {
        Map metadata = instance.getMetadata();
        String protocol = (String)metadata.get("protocol");
        String path = (String)metadata.get("path");
        ServiceConfigURL url = new ServiceConfigURL(protocol, instance.getIp(), instance.getPort(), path, instance.getMetadata());
        return new DubboServiceAddressURL(url.getUrlAddress(), url.getUrlParam(), consumerURL, null);
    }

    private Instance createInstance(URL url) {
        String category = url.getCategory("providers");
        URL newURL = url.addParameter("category", category);
        newURL = newURL.addParameter("protocol", url.getProtocol());
        newURL = newURL.addParameter("path", url.getPath());
        String ip = url.getHost();
        int port = url.getPort();
        Instance instance = new Instance();
        instance.setIp(ip);
        instance.setPort(port);
        instance.setMetadata(new HashMap<String, String>(newURL.getParameters()));
        return instance;
    }

    private NacosServiceName createServiceName(URL url) {
        return NacosServiceName.valueOf(url);
    }

    private String getServiceName(URL url) {
        return this.getServiceName(url, url.getCategory("providers"));
    }

    private String getServiceName(URL url, String category) {
        return category + SERVICE_NAME_SEPARATOR + url.getColonSeparatedKey();
    }

    private void filterEnabledInstances(Collection<Instance> instances) {
        this.filterData(instances, Instance::isEnabled);
    }

    private class RegistryChildListenerImpl
    implements EventListener {
        private final RegistryNotifier notifier;
        private final String serviceName;
        private final URL consumerUrl;
        private final NotifyListener listener;

        public RegistryChildListenerImpl(final String serviceName, final URL consumerUrl, final NotifyListener listener) {
            this.serviceName = serviceName;
            this.consumerUrl = consumerUrl;
            this.listener = listener;
            this.notifier = new RegistryNotifier(NacosRegistry.this.getUrl(), NacosRegistry.this.getDelay()){

                @Override
                protected void doNotify(Object rawAddresses) {
                    List<Instance> instances = (List<Instance>)rawAddresses;
                    if (NacosRegistry.this.isServiceNamesWithCompatibleMode(consumerUrl)) {
                        NacosInstanceManageUtil.initOrRefreshServiceInstanceList(serviceName, instances);
                        instances = NacosInstanceManageUtil.getAllCorrespondingServiceInstanceList(serviceName);
                    }
                    NacosRegistry.this.notifySubscriber(consumerUrl, listener, instances);
                }
            };
        }

        public void onEvent(Event event) {
            if (event instanceof NamingEvent) {
                NamingEvent e = (NamingEvent)event;
                this.notifier.notify(e.getInstances());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegistryChildListenerImpl that = (RegistryChildListenerImpl)o;
            return Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.consumerUrl, that.consumerUrl) && Objects.equals(this.listener, that.listener);
        }

        public int hashCode() {
            return Objects.hash(this.serviceName, this.consumerUrl, this.listener);
        }
    }

    private static interface NacosDataFilter<T> {
        public boolean accept(T var1);
    }
}

