/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.dns;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.SelfHostMetaServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.dns.util.DNSResolver;
import org.apache.dubbo.registry.dns.util.ResolveResult;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class DNSServiceDiscovery
extends SelfHostMetaServiceDiscovery {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String addressPrefix;
    private String addressSuffix;
    private long pollingCycle;
    private DNSResolver dnsResolver;
    private final ConcurrentHashMap<String, ScheduledFuture<?>> pollingExecutorMap = new ConcurrentHashMap();
    private ScheduledExecutorService pollingExecutorService;

    @Override
    public void doInitialize(URL registryURL) throws Exception {
        this.addressPrefix = registryURL.getParameter("addressPrefix", "");
        this.addressSuffix = registryURL.getParameter("addressSuffix", "");
        this.pollingCycle = registryURL.getParameter("dnsPollingCycle", 60000);
        String nameserver = registryURL.getHost();
        int port = registryURL.getPort();
        int maxQueriesPerResolve = registryURL.getParameter("maxQueriesPerResolve", 10);
        this.dnsResolver = new DNSResolver(nameserver, port, maxQueriesPerResolve);
        int scheduledThreadPoolSize = registryURL.getParameter("dnsPollingPoolSize", 1);
        this.pollingExecutorService = Executors.newScheduledThreadPool(scheduledThreadPoolSize, new NamedThreadFactory("Dubbo-DNS-Poll"));
    }

    @Override
    public void doDestroy() throws Exception {
        this.dnsResolver.destroy();
        this.pollingExecutorMap.forEach((serviceName, scheduledFuture) -> scheduledFuture.cancel(true));
        this.pollingExecutorMap.clear();
        this.pollingExecutorService.shutdown();
    }

    @Override
    public Set<String> getServices() {
        return Collections.singleton("Unsupported Method");
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceName) throws NullPointerException {
        String serviceAddress = this.addressPrefix + serviceName + this.addressSuffix;
        ResolveResult resolveResult = this.dnsResolver.resolve(serviceAddress);
        return this.toServiceInstance(serviceName, resolveResult);
    }

    @Override
    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        listener.getServiceNames().forEach(serviceName -> {
            ScheduledFuture<?> scheduledFuture = this.pollingExecutorService.scheduleAtFixedRate(() -> {
                List<ServiceInstance> instances = this.getInstances((String)serviceName);
                instances.sort(Comparator.comparingInt(Object::hashCode));
                this.notifyListener((String)serviceName, listener, instances);
            }, this.pollingCycle, this.pollingCycle, TimeUnit.MILLISECONDS);
            this.pollingExecutorMap.put((String)serviceName, scheduledFuture);
        });
    }

    @Deprecated
    public void setDnsResolver(DNSResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
    }

    private List<ServiceInstance> toServiceInstance(String serviceName, ResolveResult resolveResult) {
        int port = resolveResult.getPort().size() > 0 ? resolveResult.getPort().get(0) : 20880;
        LinkedList<ServiceInstance> instanceList = new LinkedList<ServiceInstance>();
        for (String host : resolveResult.getHostnameList()) {
            DefaultServiceInstance serviceInstance = new DefaultServiceInstance(serviceName, host, port, ScopeModelUtil.getApplicationModel(this.getUrl().getScopeModel()));
            this.fillServiceInstance(serviceInstance);
            instanceList.add(serviceInstance);
        }
        return instanceList;
    }
}

