/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata.store;

import com.google.gson.Gson;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.InstanceMetadataChangedListener;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.metadata.definition.ServiceDefinitionBuilder;
import org.apache.dubbo.metadata.definition.model.ServiceDefinition;
import org.apache.dubbo.registry.client.RegistryClusterIdentifier;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public class InMemoryWritableMetadataService
implements WritableMetadataService,
ScopeModelAware {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Lock lock = new ReentrantLock();
    private ConcurrentNavigableMap<String, SortedSet<URL>> exportedServiceURLs = new ConcurrentSkipListMap<String, SortedSet<URL>>();
    private URL metadataServiceURL;
    private ConcurrentMap<String, MetadataInfo> metadataInfos;
    private final ReentrantReadWriteLock updateLock = new ReentrantReadWriteLock();
    private final Semaphore metadataSemaphore = new Semaphore(0);
    private final Map<String, Set<String>> serviceToAppsMapping = new HashMap<String, Set<String>>();
    private String instanceMetadata;
    private ConcurrentMap<String, InstanceMetadataChangedListener> instanceMetadataChangedListenerMap = new ConcurrentHashMap<String, InstanceMetadataChangedListener>();
    private ConcurrentNavigableMap<String, SortedSet<URL>> subscribedServiceURLs = new ConcurrentSkipListMap<String, SortedSet<URL>>();
    private ConcurrentNavigableMap<String, String> serviceDefinitions = new ConcurrentSkipListMap<String, String>();
    private ApplicationModel applicationModel;
    private long metadataPublishDelayTime;

    public InMemoryWritableMetadataService() {
        this.metadataInfos = new ConcurrentHashMap<String, MetadataInfo>();
    }

    @Override
    public String serviceName() {
        return ApplicationModel.ofNullable(this.applicationModel).getApplicationName();
    }

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.metadataPublishDelayTime = ConfigurationUtils.get(applicationModel, "dubbo.application.metadata.publish.delay", 10000);
    }

    @Override
    public SortedSet<String> getSubscribedURLs() {
        return this.getAllUnmodifiableServiceURLs(this.subscribedServiceURLs);
    }

    private SortedSet<String> getAllUnmodifiableServiceURLs(Map<String, SortedSet<URL>> serviceURLs) {
        TreeSet<URL> bizURLs = new TreeSet<URL>(URLComparator.INSTANCE);
        for (Map.Entry<String, SortedSet<URL>> entry : serviceURLs.entrySet()) {
            SortedSet<URL> urls = entry.getValue();
            if (urls == null) continue;
            for (URL url : urls) {
                if (MetadataService.class.getName().equals(url.getServiceInterface())) continue;
                bizURLs.add(url);
            }
        }
        return MetadataService.toSortedStrings(bizURLs);
    }

    @Override
    public SortedSet<String> getExportedURLs(String serviceInterface, String group, String version, String protocol) {
        if ("*".equals(serviceInterface)) {
            return this.getAllUnmodifiableServiceURLs(this.exportedServiceURLs);
        }
        String serviceKey = URL.buildKey(serviceInterface, group, version);
        return Collections.unmodifiableSortedSet(this.getServiceURLs(this.exportedServiceURLs, serviceKey, protocol));
    }

    @Override
    public Set<URL> getExportedServiceURLs() {
        HashSet<URL> set = new HashSet<URL>();
        for (Map.Entry entry : this.exportedServiceURLs.entrySet()) {
            set.addAll((Collection)entry.getValue());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exportURL(URL url) {
        if (MetadataService.class.getName().equals(url.getServiceInterface())) {
            this.metadataServiceURL = url;
            return true;
        }
        this.updateLock.readLock().lock();
        try {
            String[] clusters;
            for (String cluster : clusters = this.getRegistryCluster(url).split(",")) {
                MetadataInfo metadataInfo = this.metadataInfos.computeIfAbsent(cluster, k -> new MetadataInfo(this.applicationModel.getApplicationName()));
                metadataInfo.addService(new MetadataInfo.ServiceInfo(url));
            }
            this.metadataSemaphore.release();
            boolean bl = this.addURL(this.exportedServiceURLs, url);
            return bl;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    public void addMetadataInfo(String key, MetadataInfo metadataInfo) {
        this.updateLock.readLock().lock();
        try {
            this.metadataInfos.put(key, metadataInfo);
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unexportURL(URL url) {
        if (MetadataService.class.getName().equals(url.getServiceInterface())) {
            this.metadataServiceURL = null;
            return true;
        }
        this.updateLock.readLock().lock();
        try {
            String[] clusters;
            for (String cluster : clusters = this.getRegistryCluster(url).split(",")) {
                MetadataInfo metadataInfo = (MetadataInfo)this.metadataInfos.get(cluster);
                metadataInfo.removeService(url.getProtocolServiceKey());
            }
            this.metadataSemaphore.release();
            boolean bl = this.removeURL(this.exportedServiceURLs, url);
            return bl;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    private String getRegistryCluster(URL url) {
        String registryCluster = RegistryClusterIdentifier.getExtension(url).providerKey(url);
        if (StringUtils.isEmpty(registryCluster)) {
            registryCluster = "default";
        }
        return registryCluster;
    }

    @Override
    public boolean subscribeURL(URL url) {
        return this.addURL(this.subscribedServiceURLs, url);
    }

    @Override
    public boolean unsubscribeURL(URL url) {
        return this.removeURL(this.subscribedServiceURLs, url);
    }

    @Override
    public void publishServiceDefinition(URL url) {
        try {
            String interfaceName = url.getServiceInterface();
            if (StringUtils.isNotEmpty(interfaceName) && !ProtocolUtils.isGeneric(url.getParameter("generic"))) {
                ClassLoader classLoader = url.getServiceModel() != null ? url.getServiceModel().getClassLoader() : ClassUtils.getClassLoader();
                Class<?> interfaceClass = Class.forName(interfaceName, false, classLoader);
                ServiceDefinition serviceDefinition = ServiceDefinitionBuilder.build(interfaceClass);
                Gson gson = new Gson();
                String data = gson.toJson((Object)serviceDefinition);
                this.serviceDefinitions.put(url.getServiceKey(), data);
                return;
            }
            if ("consumer".equalsIgnoreCase(url.getParameter("side"))) {
                return;
            }
            this.logger.error("publish service definition interfaceName is empty. url: " + url.toFullString());
        }
        catch (Throwable e) {
            this.logger.error("publish service definition getServiceDescriptor error. url: " + url.toFullString(), e);
        }
    }

    @Override
    public String getServiceDefinition(String interfaceName, String version, String group) {
        return (String)this.serviceDefinitions.get(URL.buildKey(interfaceName, group, version));
    }

    @Override
    public String getServiceDefinition(String serviceKey) {
        return (String)this.serviceDefinitions.get(serviceKey);
    }

    @Override
    public MetadataInfo getMetadataInfo(String revision) {
        if (StringUtils.isEmpty(revision)) {
            return null;
        }
        for (Map.Entry entry : this.metadataInfos.entrySet()) {
            MetadataInfo metadataInfo = (MetadataInfo)entry.getValue();
            if (!revision.equals(metadataInfo.calAndGetRevision())) continue;
            return metadataInfo;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("metadata not found for revision: " + revision);
        }
        return null;
    }

    @Override
    public void exportInstanceMetadata(String metadata) {
        this.instanceMetadata = metadata;
    }

    @Override
    public Map<String, InstanceMetadataChangedListener> getInstanceMetadataChangedListenerMap() {
        return this.instanceMetadataChangedListenerMap;
    }

    @Override
    public String getAndListenInstanceMetadata(String consumerId, InstanceMetadataChangedListener listener) {
        this.instanceMetadataChangedListenerMap.put(consumerId, listener);
        return this.instanceMetadata;
    }

    @Override
    public MetadataInfo getDefaultMetadataInfo() {
        if (CollectionUtils.isEmptyMap(this.metadataInfos)) {
            return null;
        }
        for (Map.Entry entry : this.metadataInfos.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase("default")) continue;
            return (MetadataInfo)entry.getValue();
        }
        return (MetadataInfo)this.metadataInfos.entrySet().iterator().next().getValue();
    }

    public void blockUntilUpdated() {
        block2: {
            try {
                this.metadataSemaphore.tryAcquire(this.metadataPublishDelayTime, TimeUnit.MILLISECONDS);
                this.metadataSemaphore.drainPermits();
                this.updateLock.writeLock().lock();
            }
            catch (InterruptedException e) {
                if (this.applicationModel.isDestroyed()) break block2;
                this.logger.warn("metadata refresh thread has been interrupted unexpectedly while waiting for update.", e);
            }
        }
    }

    public void releaseBlock() {
        this.updateLock.writeLock().unlock();
    }

    @Override
    public Map<String, MetadataInfo> getMetadataInfos() {
        return Collections.unmodifiableMap(this.metadataInfos);
    }

    void addMetaServiceURL(URL url) {
        this.metadataServiceURL = url;
    }

    @Override
    public URL getMetadataServiceURL() {
        return this.metadataServiceURL;
    }

    @Override
    public void putCachedMapping(String serviceKey, Set<String> apps) {
        this.serviceToAppsMapping.put(serviceKey, new TreeSet<String>(apps));
    }

    @Override
    public Set<String> getCachedMapping(String mappingKey) {
        return this.serviceToAppsMapping.get(mappingKey);
    }

    @Override
    public Set<String> getCachedMapping(URL consumerURL) {
        String serviceKey = ServiceNameMapping.buildMappingKey(consumerURL);
        return this.serviceToAppsMapping.get(serviceKey);
    }

    @Override
    public Set<String> removeCachedMapping(String serviceKey) {
        return this.serviceToAppsMapping.remove(serviceKey);
    }

    @Override
    public Map<String, Set<String>> getCachedMapping() {
        return this.serviceToAppsMapping;
    }

    @Override
    public void setMetadataServiceURL(URL url) {
        this.metadataServiceURL = url;
    }

    boolean addURL(Map<String, SortedSet<URL>> serviceURLs, URL url) {
        return this.executeMutually(() -> {
            SortedSet urls = serviceURLs.computeIfAbsent(url.getServiceKey(), this::newSortedURLs);
            return urls.add(url);
        });
    }

    boolean removeURL(Map<String, SortedSet<URL>> serviceURLs, URL url) {
        return this.executeMutually(() -> {
            String key = url.getServiceKey();
            SortedSet urls = serviceURLs.getOrDefault(key, null);
            if (urls == null) {
                return true;
            }
            boolean r = urls.remove(url);
            if (urls.isEmpty()) {
                serviceURLs.remove(key);
            }
            return r;
        });
    }

    private SortedSet<URL> newSortedURLs(String serviceKey) {
        return new TreeSet<URL>(URLComparator.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeMutually(Callable<Boolean> callable) {
        boolean success = false;
        try {
            this.lock.lock();
            try {
                success = callable.call();
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return success;
    }

    private SortedSet<String> getServiceURLs(Map<String, SortedSet<URL>> exportedServiceURLs, String serviceKey, String protocol) {
        SortedSet<URL> serviceURLs = exportedServiceURLs.get(serviceKey);
        if (CollectionUtils.isEmpty(serviceURLs)) {
            return Collections.emptySortedSet();
        }
        return MetadataService.toSortedStrings(serviceURLs.stream().filter(url -> this.isAcceptableProtocol(protocol, (URL)url)));
    }

    private boolean isAcceptableProtocol(String protocol, URL url) {
        return protocol == null || protocol.equals(url.getParameter("protocol")) || protocol.equals(url.getProtocol());
    }

    static class URLComparator
    implements Comparator<URL> {
        public static final URLComparator INSTANCE = new URLComparator();

        URLComparator() {
        }

        @Override
        public int compare(URL o1, URL o2) {
            return o1.toFullString().compareTo(o2.toFullString());
        }
    }
}

