/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.infra.InfraAdapter;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataParamsFilter;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.registry.client.metadata.store.InMemoryWritableMetadataService;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ServiceInstanceMetadataCustomizer
implements ServiceInstanceCustomizer {
    @Override
    public void customize(ServiceInstance serviceInstance) {
        ApplicationModel applicationModel = serviceInstance.getApplicationModel();
        ExtensionLoader<MetadataParamsFilter> loader = applicationModel.getExtensionLoader(MetadataParamsFilter.class);
        InMemoryWritableMetadataService localMetadataService = (InMemoryWritableMetadataService)WritableMetadataService.getDefaultExtension(applicationModel);
        Map<String, MetadataInfo> metadataInfos = localMetadataService.getMetadataInfos();
        if (CollectionUtils.isEmptyMap(metadataInfos)) {
            return;
        }
        MetadataInfo metadataInfo = metadataInfos.values().iterator().next();
        if (metadataInfo == null || CollectionUtils.isEmptyMap(metadataInfo.getServices())) {
            return;
        }
        MetadataInfo.ServiceInfo serviceInfo = metadataInfo.getServices().values().iterator().next();
        URL url = serviceInfo.getUrl();
        List<MetadataParamsFilter> paramsFilters = loader.getActivateExtension(url, "params-filter");
        HashMap<String, String> allParams = new HashMap<String, String>(url.getParameters());
        Map<Object, Object> extraParameters = Collections.emptyMap();
        Set<InfraAdapter> adapters = applicationModel.getExtensionLoader(InfraAdapter.class).getSupportedExtensionInstances();
        if (CollectionUtils.isNotEmpty(adapters)) {
            HashMap<String, String> inputParameters = new HashMap<String, String>();
            inputParameters.put("application", applicationModel.getApplicationName());
            for (InfraAdapter adapter : adapters) {
                extraParameters = adapter.getExtraAttributes(inputParameters);
            }
        }
        if (CollectionUtils.isEmpty(paramsFilters)) {
            serviceInstance.getMetadata().putAll(extraParameters);
            return;
        }
        serviceInstance.getMetadata().putAll(extraParameters);
        paramsFilters.forEach(filter -> {
            Object[] included = filter.instanceParamsIncluded();
            if (!ArrayUtils.isEmpty(included)) {
                for (Object p : included) {
                    if (allParams.get(p) == null) continue;
                    serviceInstance.getMetadata().put((String)p, (String)allParams.get(p));
                }
            }
        });
    }
}

