/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Map;
import java.util.SortedMap;
import org.apache.dubbo.registry.client.InstanceAddressURL;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public interface ServiceInstance
extends Serializable {
    public String getServiceName();

    public String getHost();

    public int getPort();

    public String getAddress();

    default public boolean isEnabled() {
        return true;
    }

    default public boolean isHealthy() {
        return true;
    }

    public Map<String, String> getMetadata();

    public SortedMap<String, String> getSortedMetadata();

    public String getRegistryCluster();

    public void setRegistryCluster(String var1);

    public Map<String, String> getExtendParams();

    public String getExtendParam(String var1);

    public String putExtendParam(String var1, String var2);

    public String putExtendParamIfAbsent(String var1, String var2);

    public String removeExtendParam(String var1);

    public Map<String, String> getAllParams();

    public void setApplicationModel(ApplicationModel var1);

    public ApplicationModel getApplicationModel();

    @Transient
    default public ApplicationModel getOrDefaultApplicationModel() {
        return ScopeModelUtil.getApplicationModel(this.getApplicationModel());
    }

    default public String getMetadata(String name) {
        return this.getMetadata(name, null);
    }

    default public String getMetadata(String name, String defaultValue) {
        return this.getMetadata().getOrDefault(name, defaultValue);
    }

    public InstanceAddressURL toURL();
}

