/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.probe.impl;

import java.util.List;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.qos.probe.ReadinessProbe;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;

@Activate
public class ProviderReadinessProbe
implements ReadinessProbe {
    private static FrameworkServiceRepository serviceRepository = FrameworkModel.defaultModel().getServiceRepository();

    @Override
    public boolean check() {
        List<ProviderModel> providerModelList = serviceRepository.allProviderModels();
        if (providerModelList.isEmpty()) {
            return true;
        }
        boolean hasService = false;
        block0: for (ProviderModel providerModel : providerModelList) {
            List<ProviderModel.RegisterStatedURL> statedUrls = providerModel.getStatedUrl();
            for (ProviderModel.RegisterStatedURL statedUrl : statedUrls) {
                if (!statedUrl.isRegistered()) continue;
                hasService = true;
                continue block0;
            }
        }
        return hasService;
    }
}

