/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.legacy;

import java.lang.reflect.Method;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.telnet.TelnetHandler;
import org.apache.dubbo.remoting.telnet.support.Help;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.protocol.dubbo.DubboProtocol;
import org.apache.dubbo.rpc.protocol.dubbo.filter.TraceFilter;

@Activate
@Help(parameter="[service] [method] [times]", summary="Trace the service.", detail="Trace the service.")
public class TraceTelnetHandler
implements TelnetHandler {
    @Override
    public String telnet(Channel channel, String message) {
        String times;
        String method;
        String service = (String)channel.getAttribute("telnet.service");
        if (StringUtils.isEmpty(service) && StringUtils.isEmpty(message)) {
            return "Please input service name, eg: \r\ntrace XxxService\r\ntrace XxxService xxxMethod\r\ntrace XxxService xxxMethod 10\r\nor \"cd XxxService\" firstly.";
        }
        String[] parts = message.split("\\s+");
        if (StringUtils.isEmpty(service)) {
            service = parts.length > 0 ? parts[0] : null;
            method = parts.length > 1 ? parts[1] : null;
            times = parts.length > 2 ? parts[2] : "1";
        } else {
            method = parts.length > 0 ? parts[0] : null;
            String string = times = parts.length > 1 ? parts[1] : "1";
        }
        if (StringUtils.isInteger(method)) {
            times = method;
            method = null;
        }
        if (!StringUtils.isInteger(times)) {
            return "Illegal times " + times + ", must be integer.";
        }
        Invoker<?> invoker = null;
        for (Exporter<?> exporter : DubboProtocol.getDubboProtocol().getExporters()) {
            if (!service.equals(exporter.getInvoker().getInterface().getSimpleName()) && !service.equals(exporter.getInvoker().getInterface().getName()) && !service.equals(exporter.getInvoker().getUrl().getPath())) continue;
            invoker = exporter.getInvoker();
            break;
        }
        if (invoker != null) {
            if (StringUtils.isNotEmpty(method)) {
                boolean found = false;
                for (Method m : invoker.getInterface().getMethods()) {
                    if (!m.getName().equals(method)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return "No such method " + method + " in class " + invoker.getInterface().getName();
                }
            }
        } else {
            return "No such service " + service;
        }
        TraceFilter.addTracer(invoker.getInterface(), method, channel, Integer.parseInt(times));
        return null;
    }
}

