/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.List;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.impl.Online;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceMetadata;

public class BaseOnline
implements BaseCommand {
    private static final Logger logger = LoggerFactory.getLogger(Online.class);
    public FrameworkServiceRepository serviceRepository;

    public BaseOnline(FrameworkModel frameworkModel) {
        this.serviceRepository = frameworkModel.getServiceRepository();
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        boolean hasService;
        logger.info("receive online command");
        String servicePattern = ".*";
        if (ArrayUtils.isNotEmpty(args)) {
            servicePattern = "" + args[0];
        }
        if (hasService = this.doExecute(servicePattern)) {
            return "OK";
        }
        return "service not found";
    }

    public boolean online(String servicePattern) {
        boolean hasService = false;
        List<ProviderModel> providerModelList = this.serviceRepository.allProviderModels();
        for (ProviderModel providerModel : providerModelList) {
            ServiceMetadata metadata = providerModel.getServiceMetadata();
            if (!metadata.getServiceKey().matches(servicePattern) && !metadata.getDisplayServiceKey().matches(servicePattern)) continue;
            hasService = true;
            List<ProviderModel.RegisterStatedURL> statedUrls = providerModel.getStatedUrl();
            for (ProviderModel.RegisterStatedURL statedURL : statedUrls) {
                if (statedURL.isRegistered()) continue;
                this.doExport(statedURL);
            }
        }
        return hasService;
    }

    protected boolean doExecute(String servicePattern) {
        return this.online(servicePattern);
    }

    protected void doExport(ProviderModel.RegisterStatedURL statedURL) {
        RegistryFactory registryFactory = statedURL.getRegistryUrl().getOrDefaultApplicationModel().getExtensionLoader(RegistryFactory.class).getAdaptiveExtension();
        Registry registry = registryFactory.getRegistry(statedURL.getRegistryUrl());
        registry.register(statedURL.getProviderUrl());
        statedURL.setRegistered(true);
    }
}

