/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.PropertyKeyConst;
import com.alibaba.nacos.api.config.listener.AbstractSharedListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigItem;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.utils.MD5Utils;
import org.apache.dubbo.common.utils.StringConstantFieldValuePredicate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MappingChangedEvent;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.metadata.report.identifier.BaseMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReport;
import org.apache.dubbo.metadata.store.nacos.NacosConfigServiceWrapper;
import org.apache.dubbo.rpc.RpcException;

public class NacosMetadataReport
extends AbstractMetadataReport {
    private NacosConfigServiceWrapper configService;
    private Gson gson = new Gson();
    private String group;
    private Map<String, NacosConfigListener> watchListenerMap = new ConcurrentHashMap<String, NacosConfigListener>();
    private Map<String, MappingDataListener> casListenerMap = new ConcurrentHashMap<String, MappingDataListener>();
    private MD5Utils md5Utils = new MD5Utils();

    public NacosMetadataReport(URL url) {
        super(url);
        this.configService = this.buildConfigService(url);
        this.group = url.getParameter("group", "dubbo");
    }

    public NacosConfigServiceWrapper buildConfigService(URL url) {
        Properties nacosProperties = this.buildNacosProperties(url);
        try {
            this.configService = new NacosConfigServiceWrapper(NacosFactory.createConfigService((Properties)nacosProperties));
        }
        catch (NacosException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getErrMsg(), e);
            }
            throw new IllegalStateException(e);
        }
        return this.configService;
    }

    private Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        this.setServerAddr(url, properties);
        NacosMetadataReport.setProperties(url, properties);
        return properties;
    }

    private void setServerAddr(URL url, Properties properties) {
        StringBuilder serverAddrBuilder = new StringBuilder(url.getHost()).append(':').append(url.getPort());
        String backup = url.getParameter("backup");
        if (backup != null) {
            serverAddrBuilder.append(',').append(backup);
        }
        String serverAddr = serverAddrBuilder.toString();
        properties.put("serverAddr", serverAddr);
    }

    private static void setProperties(URL url, Properties properties) {
        Map<String, String> parameters = url.getParameters(StringConstantFieldValuePredicate.of(PropertyKeyConst.class));
        properties.putAll(parameters);
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty(propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        }
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName, String defaultValue) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty(propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        } else {
            properties.setProperty(propertyName, defaultValue);
        }
    }

    @Override
    public void publishAppMetadata(SubscriberMetadataIdentifier identifier, MetadataInfo metadataInfo) {
        String content = this.gson.toJson((Object)metadataInfo);
        try {
            this.configService.publishConfig(identifier.getApplication(), identifier.getRevision(), content);
        }
        catch (NacosException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public MetadataInfo getAppMetadata(SubscriberMetadataIdentifier identifier, Map<String, String> instanceMetadata) {
        try {
            String content = this.configService.getConfig(identifier.getApplication(), identifier.getRevision(), 3000L);
            return (MetadataInfo)this.gson.fromJson(content, MetadataInfo.class);
        }
        catch (NacosException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata(providerMetadataIdentifier, serviceDefinitions);
    }

    @Override
    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata(consumerMetadataIdentifier, value);
    }

    @Override
    protected void doSaveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier, URL url) {
        this.storeMetadata(serviceMetadataIdentifier, URL.encode(url.toFullString()));
    }

    @Override
    protected void doRemoveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier) {
        this.deleteMetadata(serviceMetadataIdentifier);
    }

    @Override
    protected List<String> doGetExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        String content = this.getConfig(metadataIdentifier);
        if (StringUtils.isEmpty(content)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(URL.decode(content)));
    }

    @Override
    protected void doSaveSubscriberData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, String urlListStr) {
        this.storeMetadata(subscriberMetadataIdentifier, urlListStr);
    }

    @Override
    protected String doGetSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        return this.getConfig(subscriberMetadataIdentifier);
    }

    @Override
    public String getServiceDefinition(MetadataIdentifier metadataIdentifier) {
        return this.getConfig(metadataIdentifier);
    }

    @Override
    public boolean registerServiceAppMapping(String key, String group, String content, Object ticket) {
        try {
            if (!(ticket instanceof String)) {
                throw new IllegalArgumentException("nacos publishConfigCas requires string type ticket");
            }
            return this.configService.publishConfigCas(key, group, content, (String)ticket);
        }
        catch (NacosException e) {
            this.logger.warn("nacos publishConfigCas failed.", e);
            return false;
        }
    }

    @Override
    public ConfigItem getConfigItem(String key, String group) {
        String content = this.getConfig(key, group);
        String casMd5 = "";
        if (StringUtils.isNotEmpty(content)) {
            casMd5 = this.md5Utils.getMd5(content);
        }
        return new ConfigItem(content, casMd5);
    }

    @Override
    public Set<String> getServiceAppMapping(String serviceKey, MappingListener listener, URL url) {
        String group = "mapping";
        if (null == this.casListenerMap.get(this.buildListenerKey(serviceKey, group))) {
            this.addCasServiceMappingListener(serviceKey, group, listener);
        }
        String content = this.getConfig(serviceKey, group);
        return ServiceNameMapping.getAppNames(content);
    }

    @Override
    public Set<String> getServiceAppMapping(String serviceKey, URL url) {
        String content = this.getConfig(serviceKey, "mapping");
        return ServiceNameMapping.getAppNames(content);
    }

    private String getConfig(String dataId, String group) {
        try {
            return this.configService.getConfig(dataId, group);
        }
        catch (NacosException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    private void addCasServiceMappingListener(String serviceKey, String group, MappingListener listener) {
        MappingDataListener mappingDataListener = this.casListenerMap.computeIfAbsent(this.buildListenerKey(serviceKey, group), k -> new MappingDataListener(serviceKey, group));
        mappingDataListener.addListeners(listener);
        this.addListener(serviceKey, "mapping", mappingDataListener);
    }

    public void addListener(String key, String group, ConfigurationListener listener) {
        String listenerKey = this.buildListenerKey(key, group);
        NacosConfigListener nacosConfigListener = this.watchListenerMap.computeIfAbsent(listenerKey, k -> this.createTargetListener(key, group));
        nacosConfigListener.addListener(listener);
        try {
            this.configService.addListener(key, group, (Listener)nacosConfigListener);
        }
        catch (NacosException e) {
            this.logger.error(e.getMessage());
        }
    }

    private NacosConfigListener createTargetListener(String key, String group) {
        NacosConfigListener configListener = new NacosConfigListener();
        configListener.fillContext(key, group);
        return configListener;
    }

    private String buildListenerKey(String key, String group) {
        return key + '-' + group;
    }

    private void storeMetadata(BaseMetadataIdentifier identifier, String value) {
        try {
            boolean publishResult = this.configService.publishConfig(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), this.group, value);
            if (!publishResult) {
                throw new RuntimeException("publish nacos metadata failed");
            }
        }
        catch (Throwable t) {
            this.logger.error("Failed to put " + identifier + " to nacos " + value + ", cause: " + t.getMessage(), t);
            throw new RpcException("Failed to put " + identifier + " to nacos " + value + ", cause: " + t.getMessage(), t);
        }
    }

    private void deleteMetadata(BaseMetadataIdentifier identifier) {
        try {
            boolean publishResult = this.configService.removeConfig(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), this.group);
            if (!publishResult) {
                throw new RuntimeException("remove nacos metadata failed");
            }
        }
        catch (Throwable t) {
            this.logger.error("Failed to remove " + identifier + " from nacos , cause: " + t.getMessage(), t);
            throw new RpcException("Failed to remove " + identifier + " from nacos , cause: " + t.getMessage(), t);
        }
    }

    private String getConfig(BaseMetadataIdentifier identifier) {
        try {
            return this.configService.getConfig(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), this.group, 3000L);
        }
        catch (Throwable t) {
            this.logger.error("Failed to get " + identifier + " from nacos , cause: " + t.getMessage(), t);
            throw new RpcException("Failed to get " + identifier + " from nacos , cause: " + t.getMessage(), t);
        }
    }

    static class MappingDataListener
    implements ConfigurationListener {
        private String dataId;
        private String groupId;
        private String serviceKey;
        private Set<MappingListener> listeners;

        public MappingDataListener(String dataId, String groupId) {
            this.serviceKey = dataId;
            this.dataId = dataId;
            this.groupId = groupId;
            this.listeners = new HashSet<MappingListener>();
        }

        public void addListeners(MappingListener mappingListener) {
            this.listeners.add(mappingListener);
        }

        @Override
        public void process(ConfigChangedEvent event) {
            if (ConfigChangeType.DELETED == event.getChangeType()) {
                return;
            }
            if (!this.dataId.equals(event.getKey()) || !this.groupId.equals(event.getGroup())) {
                return;
            }
            Set<String> apps = ServiceNameMapping.getAppNames(event.getContent());
            MappingChangedEvent mappingChangedEvent = new MappingChangedEvent(this.serviceKey, apps);
            this.listeners.forEach(listener -> listener.onEvent(mappingChangedEvent));
        }
    }

    public class NacosConfigListener
    extends AbstractSharedListener {
        private Set<ConfigurationListener> listeners = new CopyOnWriteArraySet<ConfigurationListener>();
        private Map<String, String> cacheData = new ConcurrentHashMap<String, String>();

        public Executor getExecutor() {
            return null;
        }

        public void innerReceive(String dataId, String group, String configInfo) {
            String oldValue = this.cacheData.get(dataId);
            ConfigChangedEvent event = new ConfigChangedEvent(dataId, group, configInfo, this.getChangeType(configInfo, oldValue));
            if (configInfo == null) {
                this.cacheData.remove(dataId);
            } else {
                this.cacheData.put(dataId, configInfo);
            }
            this.listeners.forEach(listener -> listener.process(event));
        }

        void addListener(ConfigurationListener configurationListener) {
            this.listeners.add(configurationListener);
        }

        void removeListener(ConfigurationListener configurationListener) {
            this.listeners.remove(configurationListener);
        }

        private ConfigChangeType getChangeType(String configInfo, String oldValue) {
            if (StringUtils.isBlank(configInfo)) {
                return ConfigChangeType.DELETED;
            }
            if (StringUtils.isBlank(oldValue)) {
                return ConfigChangeType.ADDED;
            }
            return ConfigChangeType.MODIFIED;
        }
    }
}

