/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.deploy;

import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModelDestroyListener;

public class FrameworkModelCleaner
implements ScopeModelDestroyListener<FrameworkModel> {
    private static final Logger logger = LoggerFactory.getLogger(FrameworkModelCleaner.class);

    @Override
    public void onDestroy(FrameworkModel frameworkModel) {
        this.destroyFrameworkResources(frameworkModel);
    }

    private void destroyFrameworkResources(FrameworkModel frameworkModel) {
        this.destroyProtocols(frameworkModel);
    }

    private void destroyProtocols(FrameworkModel frameworkModel) {
        ExtensionLoader<Protocol> loader = frameworkModel.getExtensionLoader(Protocol.class);
        for (String protocolName : loader.getLoadedExtensions()) {
            try {
                Protocol protocol = loader.getLoadedExtension(protocolName);
                if (protocol == null) continue;
                protocol.destroy();
            }
            catch (Throwable t) {
                logger.warn(t.getMessage(), t);
            }
        }
    }
}

