/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.dubbo.common.resource.GlobalResourcesRepository;
import org.apache.dubbo.common.utils.NativeUtils;

public class ClassLoaderResourceLoader {
    private static SoftReference<Map<ClassLoader, Map<String, Set<URL>>>> classLoaderResourcesCache = null;

    public static Map<ClassLoader, Set<URL>> loadResources(String fileName, List<ClassLoader> classLoaders) {
        ConcurrentHashMap resources = new ConcurrentHashMap();
        CountDownLatch countDownLatch = new CountDownLatch(classLoaders.size());
        for (ClassLoader classLoader : classLoaders) {
            GlobalResourcesRepository.getGlobalExecutorService().submit(() -> {
                resources.put(classLoader, ClassLoaderResourceLoader.loadResources(fileName, classLoader));
                countDownLatch.countDown();
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return Collections.unmodifiableMap(new LinkedHashMap(resources));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Set<URL> loadResources(String fileName, ClassLoader currentClassLoader) {
        Map<String, Set<URL>> urlCache;
        Map<ClassLoader, Map<String, Set<URL>>> classLoaderCache;
        if (classLoaderResourcesCache == null || (classLoaderCache = classLoaderResourcesCache.get()) == null) {
            Class<ClassLoaderResourceLoader> clazz = ClassLoaderResourceLoader.class;
            // MONITORENTER : org.apache.dubbo.common.utils.ClassLoaderResourceLoader.class
            if (classLoaderResourcesCache == null || (classLoaderCache = classLoaderResourcesCache.get()) == null) {
                classLoaderCache = new ConcurrentHashMap<ClassLoader, Map<String, Set<URL>>>();
                classLoaderResourcesCache = new SoftReference<Map<ClassLoader, Map<String, Set<URL>>>>(classLoaderCache);
            }
            // MONITOREXIT : clazz
        }
        if (!classLoaderCache.containsKey(currentClassLoader)) {
            classLoaderCache.putIfAbsent(currentClassLoader, new ConcurrentHashMap());
        }
        if ((urlCache = classLoaderCache.get(currentClassLoader)).containsKey(fileName)) return urlCache.get(fileName);
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        try {
            Enumeration<URL> urls = currentClassLoader.getResources(fileName);
            boolean isNative = NativeUtils.isNative();
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    if (isNative) {
                        ClassLoaderResourceLoader.setRef(url);
                    }
                    set.add(url);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        urlCache.put(fileName, set);
        return urlCache.get(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Class<ClassLoaderResourceLoader> clazz = ClassLoaderResourceLoader.class;
        synchronized (ClassLoaderResourceLoader.class) {
            classLoaderResourcesCache = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void setRef(URL url) {
        try {
            Field field = URL.class.getDeclaredField("ref");
            field.setAccessible(true);
            field.set(url, UUID.randomUUID().toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static SoftReference<Map<ClassLoader, Map<String, Set<URL>>>> getClassLoaderResourcesCache() {
        return classLoaderResourcesCache;
    }

    static {
        GlobalResourcesRepository.registerGlobalDisposable(() -> ClassLoaderResourceLoader.destroy());
    }
}

