/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.io.Bytes;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.api.WireProtocol;

public class PortUnificationServerHandler
extends ByteToMessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortUnificationServerHandler.class);
    private final ChannelGroup channels;
    private final SslContext sslCtx;
    private final URL url;
    private final boolean detectSsl;
    private final List<WireProtocol> protocols;

    public PortUnificationServerHandler(URL url, SslContext sslCtx, boolean detectSsl, List<WireProtocol> protocols, ChannelGroup channels) {
        this.url = url;
        this.sslCtx = sslCtx;
        this.protocols = protocols;
        this.detectSsl = detectSsl;
        this.channels = channels;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.error("Unexpected exception from downstream before protocol detected.", cause);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.channels.add((Object)ctx.channel());
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 5) {
            return;
        }
        if (this.isSsl(in)) {
            this.enableSsl(ctx);
        } else {
            block5: for (WireProtocol protocol : this.protocols) {
                in.markReaderIndex();
                ProtocolDetector.Result result = protocol.detector().detect(ctx, in);
                in.resetReaderIndex();
                switch (result) {
                    case UNRECOGNIZED: {
                        continue block5;
                    }
                    case RECOGNIZED: {
                        protocol.configServerPipeline(this.url, ctx.pipeline(), this.sslCtx);
                        ctx.pipeline().remove((ChannelHandler)this);
                    }
                    case NEED_MORE_DATA: {
                        return;
                    }
                }
                return;
            }
            byte[] preface = new byte[in.readableBytes()];
            in.readBytes(preface);
            Set<String> supported = this.url.getApplicationModel().getExtensionLoader(WireProtocol.class).getSupportedExtensions();
            LOGGER.error(String.format("Can not recognize protocol from downstream=%s . preface=%s protocols=%s", ctx.channel().remoteAddress(), Bytes.bytes2hex(preface), supported));
            in.clear();
            ctx.close();
        }
    }

    private void enableSsl(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        p.addLast("ssl", (ChannelHandler)this.sslCtx.newHandler(ctx.alloc()));
        p.addLast("unificationA", (ChannelHandler)new PortUnificationServerHandler(this.url, this.sslCtx, false, this.protocols, this.channels));
        p.remove((ChannelHandler)this);
    }

    private boolean isSsl(ByteBuf buf) {
        if (this.detectSsl) {
            return SslHandler.isEncrypted((ByteBuf)buf);
        }
        return false;
    }
}

